/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.subscription;

import java.util.Collection;
import java.util.UUID;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.Bean;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;

public class AddSubscription
extends WriteRequest {
    Resource container;
    String subscriptionName;
    Collection<Item> items;
    boolean overwrite;

    public AddSubscription(Resource container, String subscriptionName, Collection<Item> items, boolean overwrite) {
        this.container = container;
        this.subscriptionName = subscriptionName;
        this.items = items;
        this.overwrite = overwrite;
    }

    public void perform(WriteGraph graph) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources mod = ModelingResources.getInstance((ReadGraph)graph);
        IEclipsePreferences pn = InstanceScope.INSTANCE.getNode("org.simantics.modeling");
        Double defaultSubscriptionItemInterval = pn.getDouble("subscriptionitem.interval", 0.0);
        Double defaultSubscriptionItemDeadband = pn.getDouble("subscriptionitem.deadband", 0.0);
        if (this.overwrite) {
            for (Resource existing : (Collection)graph.syncRequest((Read)new ObjectsWithType(this.container, l0.ConsistsOf, mod.Subscription))) {
                String name = (String)graph.getPossibleRelatedValue(existing, l0.HasName, (Binding)Bindings.STRING);
                if (!this.subscriptionName.equals(name)) continue;
                RemoverUtil.remove((WriteGraph)graph, (Resource)existing);
            }
        }
        Resource subscription = graph.newResource();
        graph.claim(subscription, l0.InstanceOf, null, mod.Subscription);
        String freshName = NameUtils.findFreshName((ReadGraph)graph, (String)this.subscriptionName, (Resource)this.container);
        graph.claimLiteral(subscription, l0.HasName, (Object)freshName);
        graph.claimLiteral(subscription, l0.HasLabel, (Object)freshName);
        graph.claim(this.container, l0.ConsistsOf, subscription);
        Binding rviBinding = ((Databoard)graph.getService(Databoard.class)).getBindingUnchecked(RVI.class);
        for (Item item : this.items) {
            Double deadband;
            Double interval;
            Resource subscriptionItem = graph.newResource();
            graph.claim(subscriptionItem, l0.InstanceOf, null, mod.Subscription_Item);
            graph.claim(subscription, l0.ConsistsOf, subscriptionItem);
            graph.claimLiteral(subscriptionItem, l0.HasName, (Object)UUID.randomUUID().toString(), (Binding)Bindings.STRING);
            if (item.label != null) {
                graph.claimLiteral(subscriptionItem, l0.HasLabel, (Object)item.label, (Binding)Bindings.STRING);
            }
            graph.claimLiteral(subscriptionItem, mod.Subscription_Item_VariableId, l0.RVI, (Object)item.resolvedName, rviBinding);
            Double d = interval = item.interval != null ? item.interval : defaultSubscriptionItemInterval;
            if (interval != null) {
                graph.claimLiteral(subscriptionItem, mod.Subscription_Item_SamplingInterval, (Object)interval, (Binding)Bindings.DOUBLE);
            }
            Double d2 = deadband = item.deadband != null ? item.deadband : defaultSubscriptionItemDeadband;
            if (deadband != null) {
                graph.claimLiteral(subscriptionItem, mod.Subscription_Item_Deadband, (Object)deadband, (Binding)Bindings.DOUBLE);
            }
            if (item.gain != null) {
                graph.claimLiteral(subscriptionItem, mod.Subscription_Item_Gain, (Object)item.gain, (Binding)Bindings.DOUBLE);
            }
            if (item.bias != null) {
                graph.claimLiteral(subscriptionItem, mod.Subscription_Item_Deadband, (Object)item.bias, (Binding)Bindings.DOUBLE);
            }
            if (item.datatype == null) continue;
            graph.claimLiteral(subscriptionItem, mod.Subscription_Item_Datatype, l0.DataType, (Object)item.datatype, Bindings.getBindingUnchecked(Datatype.class));
        }
    }

    public static class Item
    extends Bean {
        public RVI resolvedName;
        @Optional
        public Double interval;
        @Optional
        public Double deadband;
        @Optional
        public Double gain;
        @Optional
        public Double bias;
        @Optional
        public String label;
        @Optional
        public Datatype datatype;
    }
}

