/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.scl.ontologymodule;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectProcedure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.EnvironmentRequest;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.scl.ontologymodule.GraphEntityType;
import org.simantics.modeling.scl.ontologymodule.GraphPropertyRelation;
import org.simantics.modeling.scl.ontologymodule.GraphRelation;
import org.simantics.modeling.scl.ontologymodule.SCLRelationInfo;
import org.simantics.modeling.scl.ontologymodule.SCLRelationInfoRequest;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.constants.StringConstant;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EExternalConstant;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.macros.MacroRule;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.relations.SCLEntityType;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.filter.NamespaceFilter;
import org.simantics.scl.compiler.environment.specification.EnvironmentSpecification;
import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.module.LazyModule;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.SCLTypeParseException;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyModule
extends LazyModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(OntologyModule.class);
    public static final String SCL_TYPES_NAME = "SCLTypes";
    private static final String DB_MODULE = "Simantics/DB";
    private static final String VARIABLE_MODULE = "Simantics/Variable";
    private static final TCon RESOURCE = Types.con((String)"Simantics/DB", (String)"Resource");
    private static final TCon BROWSABLE = Types.con((String)"Simantics/DB", (String)"Browsable");
    private static final TCon VARIABLE = Types.con((String)"Simantics/Variable", (String)"Variable");
    private Resource ontology;
    private String defaultLocalName;
    private THashMap<Resource, Map<String, Resource>> childMaps = new THashMap();
    private ArrayList<ImportDeclaration> importDeclarations = new ArrayList();
    private Environment environment;
    private static final HashMap<String, ResourceFunctionGenerator> VALUE_GENERATOR_MAP = new HashMap();

    static {
        TVar A = Types.var((Kind)Kinds.STAR);
        VALUE_GENERATOR_MAP.put("value", (name, resource, environment) -> {
            SCLRelationInfo relationInfo = SCLRelationInfoRequest.getRelationInfo(resource, environment);
            if (relationInfo == null) {
                return null;
            }
            SCLValue value = new SCLValue(name);
            value.setType((Type)Types.forAll((TVar)A, (Type)Types.function((Type)Types.pred((TCon)BROWSABLE, (Type[])new Type[]{A}), (Type)Types.functionE((Type)A, (Type)Types.READ_GRAPH, (Type)relationInfo.rangeType))));
            value.setMacroRule((MacroRule)new RelatedValueMacroRule(resource, relationInfo, false));
            return value;
        });
        VALUE_GENERATOR_MAP.put("possibleValue", (name, resource, environment) -> {
            SCLRelationInfo relationInfo = SCLRelationInfoRequest.getRelationInfo(resource, environment);
            if (relationInfo == null) {
                return null;
            }
            SCLValue value = new SCLValue(name);
            value.setType((Type)Types.forAll((TVar)A, (Type)Types.function((Type)Types.pred((TCon)BROWSABLE, (Type[])new Type[]{A}), (Type)Types.functionE((Type)A, (Type)Types.READ_GRAPH, (Type)Types.apply((Type)Types.MAYBE, (Type)relationInfo.rangeType)))));
            value.setMacroRule((MacroRule)new RelatedValueMacroRule(resource, relationInfo, true));
            return value;
        });
    }

    public OntologyModule(ReadGraph graph, String moduleName) throws DatabaseException {
        super(moduleName);
        this.ontology = graph.getResource(moduleName);
        this.readDefaultLocalName(graph);
        this.childMaps.put((Object)this.ontology, OntologyModule.createLocalMap(graph, this.ontology));
        Pair pair = (Pair)graph.syncRequest((Read)new Read<Pair<EnvironmentSpecification, Environment>>(){

            public Pair<EnvironmentSpecification, Environment> perform(ReadGraph graph) throws DatabaseException {
                Resource indexRoot = (Resource)graph.syncRequest((Read)new IndexRoot(OntologyModule.this.ontology));
                return (Pair)graph.syncRequest((Read)new EnvironmentRequest(indexRoot){

                    protected void fillEnvironmentSpecification(EnvironmentSpecification environmentSpecification) {
                    }

                    protected String getRootModuleName() {
                        return OntologyModule.SCL_TYPES_NAME;
                    }
                });
            }
        });
        for (ImportDeclaration decl : ((EnvironmentSpecification)pair.first).imports) {
            this.importDeclarations.add(decl.hidden());
        }
        this.environment = (Environment)pair.second;
    }

    private void readDefaultLocalName(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        this.defaultLocalName = (String)graph.getPossibleRelatedValue(this.ontology, L0.Ontology_defaultLocalName);
        if (this.defaultLocalName == null) {
            this.defaultLocalName = "";
        }
    }

    public String getDefaultLocalName() {
        return this.defaultLocalName;
    }

    public List<ImportDeclaration> getDependencies() {
        return this.importDeclarations;
    }

    private ResourceSearchResult getResourceOrSuffixedResource(String name) {
        int p;
        Map<String, Resource> localMap = (Map<String, Resource>)this.childMaps.get((Object)this.ontology);
        if (localMap == null) {
            return null;
        }
        Resource parent = this.ontology;
        while ((p = name.indexOf(46)) >= 0) {
            String localName = name.substring(0, p);
            parent = (Resource)localMap.get(localName);
            if (parent == null) {
                return null;
            }
            name = name.substring(p + 1);
            localMap = this.getLocalMap(parent);
            if (localMap != null) continue;
            return null;
        }
        Resource child = (Resource)localMap.get(name);
        if (child != null) {
            return new JustResource(child);
        }
        return new ResourceAndSuffix(parent, name);
    }

    private Resource getResource(String name) {
        ResourceSearchResult searchResult = this.getResourceOrSuffixedResource(name);
        if (searchResult instanceof JustResource) {
            return ((JustResource)searchResult).resource;
        }
        return null;
    }

    private Map<String, Resource> getLocalMap(Resource parent) {
        Map<String, Resource> localMap = (Map<String, Resource>)this.childMaps.get((Object)parent);
        if (localMap == null) {
            if (this.childMaps.contains((Object)parent)) {
                return null;
            }
            localMap = OntologyModule.createLocalMap(parent);
            this.childMaps.put((Object)parent, localMap);
        }
        return localMap;
    }

    private static Map<String, Resource> createLocalMap(final Resource parent) {
        ReadGraph graph = (ReadGraph)SCLContext.getCurrent().get((Object)"graph");
        if (graph != null) {
            return OntologyModule.createLocalMap(graph, parent);
        }
        try {
            return (Map)Simantics.getSession().syncRequest((Read)new Read<Map<String, Resource>>(){

                public Map<String, Resource> perform(ReadGraph graph) throws DatabaseException {
                    return OntologyModule.createLocalMap(graph, parent);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Map<String, Resource> createLocalMap(ReadGraph graph, Resource parent) {
        try {
            return (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(parent));
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected SCLValue createValue(String name) {
        ResourceSearchResult searchResult = this.getResourceOrSuffixedResource(name);
        if (searchResult instanceof JustResource) {
            Resource resource = ((JustResource)searchResult).resource;
            SCLValue value = new SCLValue(Name.create((String)this.getName(), (String)name));
            value.setType((Type)RESOURCE);
            value.setExpression((Expression)new EExternalConstant((Object)resource, (Type)RESOURCE));
            value.setInlineInSimplification(true);
            return value;
        }
        if (searchResult instanceof ResourceAndSuffix) {
            ResourceAndSuffix resourceAndSuffix = (ResourceAndSuffix)searchResult;
            ResourceFunctionGenerator generator = VALUE_GENERATOR_MAP.get(resourceAndSuffix.suffix);
            if (generator == null) {
                return null;
            }
            return generator.createValue(Name.create((String)this.getName(), (String)name), resourceAndSuffix.resource, this.environment);
        }
        return null;
    }

    protected SCLRelation createRelation(String name) {
        final Resource resource = this.getResource(name);
        if (resource == null) {
            return null;
        }
        ReadGraph graph = (ReadGraph)SCLContext.getCurrent().get((Object)"graph");
        if (graph != null) {
            return OntologyModule.createRelation(graph, resource);
        }
        try {
            return (SCLRelation)Simantics.getSession().syncRequest((Read)new Read<SCLRelation>(){

                public SCLRelation perform(ReadGraph graph) throws DatabaseException {
                    return OntologyModule.createRelation(graph, resource);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SCLRelation createRelation(ReadGraph graph, Resource relation) {
        Type valueType;
        Layer0 L0;
        block4: {
            try {
                L0 = Layer0.getInstance((ReadGraph)graph);
                if (graph.isInstanceOf(relation, L0.Relation)) break block4;
                return null;
            }
            catch (DatabaseException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (graph.isInstanceOf(relation, L0.PropertyRelation) && graph.isInstanceOf(relation, L0.FunctionalRelation) && (valueType = OntologyModule.getValueType(graph, relation)) != null) {
            return new GraphPropertyRelation(relation, valueType);
        }
        Resource inverseRelation = graph.getPossibleInverse(relation);
        return new GraphRelation(relation, OntologyModule.getSelectivity(graph, relation), inverseRelation, OntologyModule.getSelectivity(graph, inverseRelation));
    }

    protected SCLEntityType createEntityType(String name) {
        final Resource resource = this.getResource(name);
        if (resource == null) {
            return null;
        }
        ReadGraph graph = (ReadGraph)SCLContext.getCurrent().get((Object)"graph");
        if (graph != null) {
            return this.createEntityType(graph, resource);
        }
        try {
            return (SCLEntityType)Simantics.getSession().syncRequest((Read)new Read<SCLEntityType>(){

                public SCLEntityType perform(ReadGraph graph) throws DatabaseException {
                    return OntologyModule.this.createEntityType(graph, resource);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private SCLEntityType createEntityType(ReadGraph graph, Resource type) {
        block3: {
            try {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                if (graph.isInstanceOf(type, L0.Type)) break block3;
                return null;
            }
            catch (DatabaseException e) {
                e.printStackTrace();
                return null;
            }
        }
        return new GraphEntityType(graph, type);
    }

    private static double getSelectivity(ReadGraph graph, Resource relation) throws DatabaseException {
        if (relation == null) {
            return Double.POSITIVE_INFINITY;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(relation, L0.FunctionalRelation)) {
            return 1.0;
        }
        return 10.0;
    }

    private static Type getValueType(ReadGraph graph, Resource relation) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Type valueType = OntologyModule.parseValueType((String)graph.getPossibleRelatedValue(relation, L0.RequiresValueType, (Binding)Bindings.STRING));
        if (valueType != null) {
            return valueType;
        }
        Resource range = graph.getPossibleObject(relation, L0.HasRange);
        if (range != null) {
            for (Resource valueTypeLiteral : graph.getAssertedObjects(range, L0.HasValueType)) {
                valueType = OntologyModule.parseValueType((String)graph.getValue(valueTypeLiteral, (Binding)Bindings.STRING));
                if (valueType == null) continue;
                return valueType;
            }
        }
        return null;
    }

    private static Type parseValueType(String valueTypeString) {
        if (valueTypeString == null) {
            return null;
        }
        try {
            return Types.parseType((String)valueTypeString);
        }
        catch (SCLTypeParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void findValuesForPrefix(String prefix, NamespaceFilter filter, TObjectProcedure<SCLValue> proc) {
        int p;
        Map<String, Resource> localMap = (Map<String, Resource>)this.childMaps.get((Object)this.ontology);
        if (localMap == null) {
            return;
        }
        String namePrefix = "";
        while ((p = prefix.indexOf(46)) >= 0) {
            String localName = prefix.substring(0, p);
            Resource newParent = (Resource)localMap.get(localName);
            if (newParent == null) {
                return;
            }
            prefix = prefix.substring(p + 1);
            namePrefix = String.valueOf(namePrefix) + localName + ".";
            localMap = this.getLocalMap(newParent);
            if (localMap != null) continue;
            return;
        }
        for (String name : localMap.keySet()) {
            if (!name.startsWith(prefix) || !filter.isValueIncluded(name)) continue;
            proc.execute((Object)this.getValue(String.valueOf(namePrefix) + name));
        }
    }

    public void findValuesForPrefix(String prefix, NamespaceFilter filter, Consumer<SCLValue> consumer) {
        int p;
        Map<String, Resource> localMap = (Map<String, Resource>)this.childMaps.get((Object)this.ontology);
        if (localMap == null) {
            return;
        }
        String namePrefix = "";
        while ((p = prefix.indexOf(46)) >= 0) {
            String localName = prefix.substring(0, p);
            Resource newParent = (Resource)localMap.get(localName);
            if (newParent == null) {
                return;
            }
            prefix = prefix.substring(p + 1);
            namePrefix = String.valueOf(namePrefix) + localName + ".";
            localMap = this.getLocalMap(newParent);
            if (localMap != null) continue;
            return;
        }
        for (String name : localMap.keySet()) {
            if (!name.startsWith(prefix) || !filter.isValueIncluded(name)) continue;
            consumer.accept(this.getValue(String.valueOf(namePrefix) + name));
        }
    }

    public void findTypesForPrefix(String prefix, NamespaceFilter instance, Consumer<TCon> consumer) {
    }

    public void dispose() {
        this.childMaps.clear();
        this.childMaps = null;
        this.ontology = null;
        this.environment = null;
    }

    public String toString() {
        return "OntologyModule " + this.getName();
    }

    public ClassLoader getParentClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    private static class JustResource
    implements ResourceSearchResult {
        public final Resource resource;

        public JustResource(Resource resource) {
            this.resource = resource;
        }

        public String toString() {
            return "JustResource(" + this.resource + ")";
        }
    }

    private static class RelatedValueMacroRule
    implements MacroRule {
        private final Resource relation;
        private final SCLRelationInfo relationInfo;
        private final boolean optionalValue;

        public RelatedValueMacroRule(Resource relation, SCLRelationInfo relationInfo, boolean optionalValue) {
            this.relation = relation;
            this.relationInfo = relationInfo;
            this.optionalValue = optionalValue;
        }

        private Expression applyWithSubject(SimplificationContext context, Type subjectType, Expression evidence, Expression subject) {
            if (Types.equals((Type)subjectType, (Type)RESOURCE)) {
                return new EApply(9223372034707292160L, (Type)Types.READ_GRAPH, context.getConstant(Name.create((String)OntologyModule.DB_MODULE, (String)(this.optionalValue ? "possibleRelatedValue2" : "relatedValue2")), new Type[]{this.relationInfo.rangeType}), new Expression[]{subject, new EExternalConstant((Object)this.relation, (Type)RESOURCE)});
            }
            if (Types.equals((Type)subjectType, (Type)VARIABLE)) {
                return new EApply(9223372034707292160L, (Type)Types.READ_GRAPH, context.getConstant(Name.create((String)OntologyModule.DB_MODULE, (String)(this.optionalValue ? "untypedPossiblePropertyValue" : "untypedPropertyValue")), new Type[]{this.relationInfo.rangeType}), new Expression[]{subject, new ELiteral((Constant)new StringConstant(this.relationInfo.name))});
            }
            return new EApply(9223372034707292160L, (Type)Types.READ_GRAPH, context.getConstant(Name.create((String)OntologyModule.DB_MODULE, (String)(this.optionalValue ? "genericPossibleRelatedValue" : "genericRelatedValue")), new Type[]{subjectType, this.relationInfo.rangeType}), new Expression[]{evidence, subject, new EExternalConstant((Object)this.relation, (Type)RESOURCE)});
        }

        public Expression apply(SimplificationContext context, Type[] typeParameters, EApply apply) {
            Type subjectType = typeParameters[0];
            if (apply.parameters.length == 1) {
                Variable subject = new Variable("subject", subjectType);
                return new ESimpleLambda(subject, this.applyWithSubject(context, subjectType, apply.parameters[0], (Expression)new EVariable(subject)));
            }
            if (apply.parameters.length >= 2) {
                Expression valueReplacement = this.applyWithSubject(context, subjectType, apply.parameters[0], apply.parameters[1]);
                if (apply.parameters.length == 2) {
                    return valueReplacement;
                }
                apply.set(valueReplacement, Arrays.copyOfRange(apply.parameters, 2, apply.parameters.length));
                return apply;
            }
            LOGGER.error("Application of relation following functions should have at least one parameter (the evidence of Browsable).");
            return null;
        }
    }

    private static class ResourceAndSuffix
    implements ResourceSearchResult {
        public final Resource resource;
        public final String suffix;

        public ResourceAndSuffix(Resource resource, String suffix) {
            this.resource = resource;
            this.suffix = suffix;
        }

        public String toString() {
            return "ResourceAndSuffix(" + this.resource + ", " + this.suffix + ")";
        }
    }

    @FunctionalInterface
    private static interface ResourceFunctionGenerator {
        public SCLValue createValue(Name var1, Resource var2, Environment var3);
    }

    private static interface ResourceSearchResult {
    }
}

