/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.migration;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.migration.MigrationState;
import org.simantics.db.layer0.migration.MigrationStep;
import org.simantics.db.layer0.migration.MigrationUtils;
import org.simantics.db.layer0.migration.NullWriter;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.reporting.AbstractSCLReportingHandler;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;

public class SCLScriptMigrationStep
implements MigrationStep {
    private String scriptId;
    private String script;

    public SCLScriptMigrationStep(ReadGraph graph, Resource step) throws DatabaseException {
        this.scriptId = NameUtils.getSafeName((ReadGraph)graph, (Resource)step);
        this.script = (String)graph.getRelatedValue(step, ModelingResources.getInstance((ReadGraph)graph).Migration_SCLScriptMigrationStep_script, (Binding)Bindings.STRING);
    }

    public void applyTo(IProgressMonitor monitor, Session session, MigrationState state) throws DatabaseException {
        Collection roots = (Collection)state.getProperty("currentRootResources");
        if (!roots.isEmpty()) {
            PrintWriter log = (PrintWriter)MigrationUtils.getProperty((MigrationState)state, (String)"messageLogWriter", (Object)NullWriter.PRINT_INSTANCE);
            this.runScript(monitor, roots, log);
        }
    }

    private void runScript(IProgressMonitor monitor, Collection<Resource> roots, PrintWriter log) throws DatabaseException {
        log.format("## Running SCL Script Migration Step `%s` ##%n", this.scriptId);
        ReportingHandler rh = new ReportingHandler(log);
        Map<Resource, String> rootNames = this.mapNames(roots);
        for (Resource root : roots) {
            log.format("### Running script for root `%s` ###%n", rootNames.get(root));
            CommandSession session = new CommandSession(SCLOsgi.MODULE_REPOSITORY, (SCLReportingHandler)rh);
            session.setVariable("root", Types.RESOURCE, (Object)root);
            session.execute((Reader)new StringReader(this.script), (SCLReportingHandler)rh);
        }
    }

    private Map<Resource, String> mapNames(Collection<Resource> roots) throws DatabaseException {
        return (Map)Simantics.getSession().syncRequest(graph -> this.mapNames(graph, roots));
    }

    private Map<Resource, String> mapNames(ReadGraph graph, Collection<Resource> roots) throws DatabaseException {
        HashMap<Resource, String> map = new HashMap<Resource, String>();
        for (Resource r : roots) {
            map.put(r, NameUtils.getSafeName((ReadGraph)graph, (Resource)r));
        }
        return map;
    }

    private static class ReportingHandler
    extends AbstractSCLReportingHandler {
        PrintWriter log;

        public ReportingHandler(PrintWriter log) {
            this.log = log;
        }

        public void print(String text) {
            this.log.println(text);
        }

        public void printError(String error) {
            this.log.println("ERROR: " + error);
        }
    }
}

