/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.modeling.PropertyVariables;
import org.simantics.utils.datastructures.hints.HintContext;

public class PropertyVariablesImpl
extends HintContext
implements PropertyVariables,
IAdaptable {
    private final Variable container;
    private final Variable configuration;
    private final Variable visualized;
    private final Variable modified;
    private final String suffix;

    public PropertyVariablesImpl(Variable container, Variable visualized, Variable modified) {
        this(container, null, visualized, modified, null);
    }

    public PropertyVariablesImpl(Variable container, Variable visualized, Variable modified, String suffix) {
        this(container, null, visualized, modified, suffix);
    }

    public PropertyVariablesImpl(Variable container, Variable configuration, Variable visualized, Variable modified) {
        this(container, configuration, visualized, modified, null);
    }

    public PropertyVariablesImpl(Variable container, Variable configuration, Variable visualized, Variable modified, String suffix) {
        if (visualized == null) {
            throw new NullPointerException("null visualized variable");
        }
        this.container = container;
        this.configuration = configuration;
        this.visualized = visualized;
        this.modified = modified;
        this.suffix = suffix;
        this.setHintWithoutNotification(SelectionHints.KEY_MAIN, visualized);
        this.setHintWithoutNotification(SelectionHints.KEY_SELECTION_PROPERTY, visualized);
    }

    @Override
    public Variable getContainer() {
        return this.container;
    }

    @Override
    public Variable getConfiguration() {
        return this.configuration;
    }

    @Override
    public Variable getVisualVariable() {
        return this.visualized;
    }

    @Override
    public Variable getModificationVariable() {
        return this.modified;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public PropertyVariables withSuffix(String suffix) {
        return new PropertyVariablesImpl(this.container, this.visualized, this.modified, suffix);
    }

    @Override
    public PropertyVariables resolved(ReadGraph graph) throws DatabaseException {
        if (this.suffix == null) {
            return this;
        }
        Variable c = this.configuration;
        Variable v = this.visualized;
        Variable m = this.modified;
        if (c != null) {
            c = c.browsePossible(graph, this.suffix);
        }
        if (v != null) {
            v = v.browsePossible(graph, this.suffix);
        }
        if (v == null) {
            return null;
        }
        if (m != null) {
            m = m.browsePossible(graph, this.suffix);
        }
        return new PropertyVariablesImpl(this.container, c, v, m, null);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.container == null ? 0 : this.container.hashCode());
        result = 31 * result + (this.configuration == null ? 0 : this.configuration.hashCode());
        result = 31 * result + (this.modified == null ? 0 : this.modified.hashCode());
        result = 31 * result + (this.visualized == null ? 0 : this.visualized.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyVariablesImpl other = (PropertyVariablesImpl)obj;
        if (this.container == null ? other.container != null : !this.container.equals(other.container)) {
            return false;
        }
        if (this.configuration == null ? other.configuration != null : !this.configuration.equals(other.configuration)) {
            return false;
        }
        if (this.modified == null ? other.modified != null : !this.modified.equals(other.modified)) {
            return false;
        }
        return !(this.visualized == null ? other.visualized != null : !this.visualized.equals(other.visualized));
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Variable.class) {
            return this.visualized;
        }
        return null;
    }

    public static List<PropertyVariables> resolve(ReadGraph graph, List<PropertyVariables> vars) throws DatabaseException {
        ArrayList<PropertyVariables> result = new ArrayList<PropertyVariables>(vars.size());
        for (PropertyVariables var : vars) {
            PropertyVariables v = var.resolved(graph);
            if (v == null) continue;
            result.add(v);
        }
        return result;
    }
}

