/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.typicals;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.request.Write;
import org.simantics.modeling.typicals.SyncTypicalTemplatesToInstances;
import org.simantics.modeling.ui.documents.OpenPlainTextDocumentAdapter;
import org.simantics.modeling.ui.property.TypicalPropertyTester;
import org.simantics.modeling.ui.typicals.RuleChooserDialog;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.utils.ui.ErrorLogger;

public class SyncCurrentTypicalTemplateToInstances
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        RuleChooserDialog.RuleResult result;
        Session session;
        IResourceEditorInput input;
        block7: {
            Shell shell;
            block6: {
                shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
                IEditorPart activeEditor = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
                input = (IResourceEditorInput)activeEditor.getEditorInput();
                session = Simantics.getSession();
                if (TypicalPropertyTester.isTypicalMasterEditor((RequestProcessor)session, input.getResource())) break block6;
                MessageDialog.openInformation((Shell)shell, (String)"Not Synchronizing", (String)"Currently active editor is not a typical diagram template editor.");
                return null;
            }
            result = RuleChooserDialog.choose(shell, "Synchronizing typical template to all its instances in the currently active model.", new Resource[]{input.getResource()});
            if (result != null) break block7;
            return null;
        }
        try {
            session.markUndoPoint();
            SyncTypicalTemplatesToInstances req = new SyncTypicalTemplatesToInstances(result.selectedRules, new Resource[]{input.getResource()}).logging(result.logging);
            session.syncRequest((Write)req);
            if (result.logging) {
                for (Resource log : req.logs) {
                    new OpenPlainTextDocumentAdapter().openEditor(log);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        return null;
    }
}

