/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.pdf;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.simantics.browsing.ui.common.views.DefaultFilterStrategy;
import org.simantics.browsing.ui.common.views.IFilterStrategy;
import org.simantics.modeling.requests.CollectionResult;
import org.simantics.modeling.requests.Node;
import org.simantics.modeling.ui.pdf.DiagramPrinter;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.ISelectionUtils;

public class NodeTree
extends Composite {
    protected Display display;
    protected LocalResourceManager resourceManager;
    protected Color noDiagramColor;
    protected IFilterStrategy filterStrategy = new DefaultFilterStrategy();
    protected Text filter;
    protected Matcher matcher = null;
    protected CheckboxTreeViewer tree;
    protected TreePath[] noFilterExpandedPaths;
    protected Set<Node> selectedNodes;
    protected CheckStateCache checkStateCache = new CheckStateCache();
    protected Runnable selectionChangeListener;
    protected CollectionResult nodes;
    private Runnable resetFilter = () -> this.resetFilterString(this.filter.getText());

    public NodeTree(Composite parent, Set<Node> selectedNodes) {
        super(parent, 0);
        this.display = this.getDisplay();
        this.selectedNodes = selectedNodes;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this);
        this.noDiagramColor = this.getDisplay().getSystemColor(16);
        GridLayoutFactory.fillDefaults().spacing(20, 10).numColumns(3).applyTo((Composite)this);
        this.createFilter(this);
        this.createTree(this);
        this.createButtons(this);
    }

    public void setSelectionChangeListener(Runnable r) {
        this.selectionChangeListener = r;
    }

    public void setInput(CollectionResult nodes) {
        this.nodes = nodes;
        this.tree.setInput((Object)nodes);
        this.resetFilterString(this.filter.getText());
    }

    private void createFilter(Composite parent) {
        Label filterLabel = new Label(parent, 0);
        filterLabel.setText("Fi&lter:");
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)filterLabel);
        this.filter = new Text(parent, 2048);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.filter);
        this.filter.addModifyListener(e -> this.display.timerExec(500, this.resetFilter));
    }

    private void createTree(Composite parent) {
        this.tree = new CheckboxTreeViewer(parent, 67586);
        this.tree.setUseHashlookup(true);
        GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo(this.tree.getControl());
        this.tree.getControl().setToolTipText("Selects the diagrams to include in the exported document.");
        this.tree.setAutoExpandLevel(2);
        this.tree.addCheckStateListener((ICheckStateListener)new CheckStateListener());
        this.tree.setContentProvider((IContentProvider)new NodeTreeContentProvider());
        this.tree.setLabelProvider((IBaseLabelProvider)new NodeLabelProvider());
        this.tree.setCheckStateProvider((ICheckStateProvider)new NodeCheckStateProvider());
        this.tree.setComparator(new ViewerComparator((Comparator)AlphanumComparator.CASE_INSENSITIVE_COMPARATOR));
        this.tree.setFilters(new ViewerFilter[]{new NodeFilter()});
    }

    private void createButtons(Composite parent) {
        Composite bar = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)bar);
        bar.setLayout((Layout)new RowLayout());
        Button selectAll = new Button(bar, 8);
        selectAll.setText("Select &All");
        selectAll.setToolTipText("Select All Visible Diagrams");
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NodeTree.this.selectedNodes.addAll(NodeTree.this.filter.getText().isEmpty() ? NodeTree.this.nodes.breadthFirstFlatten(CollectionResult.DIAGRAM_RESOURCE_FILTER) : NodeTree.this.getVisibleNodes());
                NodeTree.this.refreshTree(true);
                NodeTree.this.fireChangeListener();
                NodeTree.this.scheduleFocusTree();
            }
        });
        Button clearSelection = new Button(bar, 8);
        clearSelection.setText("&Deselect All");
        clearSelection.setToolTipText("Deselect All Visible Diagrams");
        clearSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NodeTree.this.filter.getText().isEmpty()) {
                    NodeTree.this.selectedNodes.clear();
                } else {
                    NodeTree.this.selectedNodes.removeAll(NodeTree.this.getVisibleNodes());
                }
                NodeTree.this.refreshTree(true);
                NodeTree.this.fireChangeListener();
                NodeTree.this.scheduleFocusTree();
            }
        });
        Button expand = new Button(bar, 8);
        expand.setText("&Expand");
        expand.setToolTipText("Fully Expand Selected Nodes or All Nodes");
        expand.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITreeSelection ss = NodeTree.this.tree.getStructuredSelection();
                if (ss.isEmpty()) {
                    NodeTree.this.tree.expandAll();
                } else {
                    for (Object n : ss.toList()) {
                        NodeTree.this.tree.expandToLevel(n, -1);
                    }
                }
                NodeTree.this.scheduleFocusTree();
            }
        });
        Button collapse = new Button(bar, 8);
        collapse.setText("&Collapse");
        collapse.setToolTipText("Collapse Selected Nodes or All Nodes");
        collapse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITreeSelection ss = NodeTree.this.tree.getStructuredSelection();
                if (ss.isEmpty()) {
                    NodeTree.this.tree.collapseAll();
                } else {
                    for (Object n : ss.toList()) {
                        NodeTree.this.tree.collapseToLevel(n, -1);
                    }
                }
                NodeTree.this.scheduleFocusTree();
            }
        });
    }

    protected void fireChangeListener() {
        if (this.selectionChangeListener != null) {
            this.selectionChangeListener.run();
        }
    }

    protected void scheduleFocusTree() {
        this.display.asyncExec(() -> {
            if (!this.tree.getTree().isDisposed() && !this.tree.getTree().isFocusControl()) {
                this.tree.getTree().setFocus();
            }
        });
    }

    private Collection<Node> getVisibleNodes() {
        ArrayList<Node> result = new ArrayList<Node>();
        ArrayDeque<TreeItem> todo = new ArrayDeque<TreeItem>();
        TreeItem[] treeItemArray = this.tree.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            todo.add(ti);
            ++n2;
        }
        while (!todo.isEmpty()) {
            TreeItem item = (TreeItem)todo.removeLast();
            Node node = (Node)item.getData();
            if (node != null) {
                result.add(node);
            }
            TreeItem[] treeItemArray2 = item.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem child = treeItemArray2[n4];
                todo.add(child);
                ++n4;
            }
        }
        return result;
    }

    private void resetFilterString(String filterString) {
        TreePath[] restoreExpansions = null;
        String patternString = this.filterStrategy.toPatternString(filterString);
        if (patternString == null) {
            if (this.matcher != null) {
                restoreExpansions = this.noFilterExpandedPaths;
                this.noFilterExpandedPaths = null;
            }
            this.matcher = null;
        } else {
            if (this.matcher == null) {
                this.noFilterExpandedPaths = this.tree.getExpandedTreePaths();
            }
            this.matcher = Pattern.compile(patternString).matcher("");
        }
        this.refreshTree(false);
        if (restoreExpansions != null) {
            this.tree.setExpandedTreePaths(restoreExpansions);
        } else {
            this.tree.expandAll();
        }
    }

    protected static boolean hasDiagram(Node n) {
        return n.getDiagramResource() != null;
    }

    protected static boolean hasDiagramDeep(Node n) {
        if (NodeTree.hasDiagram(n)) {
            return true;
        }
        for (Node c : n.getChildren()) {
            if (!NodeTree.hasDiagramDeep(c)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSomethingSelected(Node node) {
        if (this.selectedNodes.contains(node)) {
            return true;
        }
        Collection children = node.getChildren();
        if (!children.isEmpty()) {
            for (Node child : children) {
                if (!NodeTree.hasDiagramDeep(child) || !this.isSomethingSelected(child)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isFullySelected(Node node) {
        if (this.selectedNodes.contains(node)) {
            return true;
        }
        int selectedCount = 0;
        boolean allSelected = true;
        Collection children = node.getChildren();
        if (!children.isEmpty()) {
            for (Node child : children) {
                if (!NodeTree.hasDiagramDeep(child)) continue;
                boolean selected = this.isFullySelected(child);
                allSelected &= selected;
                selectedCount += selected ? 1 : 0;
                if (!selected) break;
            }
        }
        return allSelected && selectedCount > 0;
    }

    protected boolean isPartiallySelected(Node node) {
        return !this.selectedNodes.contains(node) && this.isSomethingSelected(node) && !this.isFullySelected(node);
    }

    protected void refreshTree(boolean invalidateCheckStateCache) {
        if (invalidateCheckStateCache) {
            this.checkStateCache.invalidate();
        }
        this.tree.refresh();
    }

    public void refreshTree() {
        this.refreshTree(true);
    }

    public boolean addOrRemoveSelection(Node node, boolean add) {
        boolean changed = false;
        if (NodeTree.hasDiagram(node) && (changed = add ? this.selectedNodes.add(node) : this.selectedNodes.remove(node))) {
            this.checkStateCache.invalidate(node);
        }
        return changed;
    }

    public boolean addOrRemoveSelectionRec(Node node, boolean add) {
        boolean changed = false;
        changed |= this.addOrRemoveSelection(node, add);
        for (Node child : node.getChildren()) {
            changed |= this.addOrRemoveSelectionRec(child, add);
        }
        return changed;
    }

    private static class CheckStateCache {
        Map<Node, Boolean> isChecked = new HashMap<Node, Boolean>();
        Map<Node, Boolean> isGrayed = new HashMap<Node, Boolean>();

        private CheckStateCache() {
        }

        public void invalidate(Node n) {
            while (n != null) {
                this.isChecked.remove(n);
                this.isGrayed.remove(n);
                n = n.getParent();
            }
        }

        public void invalidate() {
            this.isChecked.clear();
            this.isGrayed.clear();
        }
    }

    private class CheckStateListener
    implements ICheckStateListener {
        private CheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            boolean checked = event.getChecked();
            Node checkedNode = (Node)event.getElement();
            HashSet<Node> nodes = new HashSet<Node>();
            Set selection = ISelectionUtils.filterSetSelection((Object)NodeTree.this.tree.getSelection(), Node.class);
            if (selection.contains(checkedNode)) {
                nodes.addAll(selection);
            } else {
                NodeTree.this.tree.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            nodes.add(checkedNode);
            for (Node node : nodes) {
                NodeTree.this.addOrRemoveSelectionRec(node, checked);
            }
            NodeTree.this.tree.refresh();
            NodeTree.this.fireChangeListener();
        }
    }

    private class NodeCheckStateProvider
    implements ICheckStateProvider {
        private NodeCheckStateProvider() {
        }

        public boolean isChecked(Object element) {
            Node n = (Node)element;
            Boolean cache = NodeTree.this.checkStateCache.isChecked.get(n);
            if (cache != null) {
                return cache;
            }
            boolean checked = NodeTree.this.isSomethingSelected(n);
            NodeTree.this.checkStateCache.isChecked.put(n, checked);
            return checked;
        }

        public boolean isGrayed(Object element) {
            Node n = (Node)element;
            Boolean cache = NodeTree.this.checkStateCache.isGrayed.get(n);
            if (cache != null) {
                return cache;
            }
            boolean grayed = n.getDiagramResource() == null && NodeTree.this.isPartiallySelected(n);
            NodeTree.this.checkStateCache.isGrayed.put(n, grayed);
            return grayed;
        }
    }

    private class NodeFilter
    extends ViewerFilter {
        private NodeFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (NodeTree.this.matcher == null) {
                return true;
            }
            Node node = (Node)element;
            boolean matches = NodeTree.this.matcher.reset(node.getName().toLowerCase()).matches();
            if (matches) {
                return true;
            }
            for (Node child : node.getChildren()) {
                if (!this.select(viewer, element, child)) continue;
                return true;
            }
            return false;
        }
    }

    private class NodeLabelProvider
    extends CellLabelProvider {
        private NodeLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object e = cell.getElement();
            if (e instanceof Node) {
                Node n = (Node)e;
                String name = DiagramPrinter.formDiagramName(n, false);
                cell.setText(name);
                if (n.getDiagramResource() == null) {
                    cell.setForeground(NodeTree.this.noDiagramColor);
                } else {
                    cell.setForeground(null);
                }
            } else {
                cell.setText("invalid input: " + e.getClass().getSimpleName());
            }
        }
    }

    private static class NodeTreeContentProvider
    implements ITreeContentProvider {
        private NodeTreeContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof CollectionResult) {
                return ((CollectionResult)inputElement).roots.toArray();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            Node n = (Node)element;
            Collection children = n.getChildren();
            if (children.isEmpty()) {
                return false;
            }
            for (Node c : children) {
                if (!NodeTree.hasDiagramDeep(c)) continue;
                return true;
            }
            return false;
        }

        public Object getParent(Object element) {
            return ((Node)element).getParent();
        }

        public Object[] getChildren(Object parentElement) {
            Node n = (Node)parentElement;
            ArrayList<Node> result = new ArrayList<Node>(n.getChildren().size());
            for (Node c : n.getChildren()) {
                if (!NodeTree.hasDiagramDeep(c)) continue;
                result.add(c);
            }
            return result.toArray();
        }
    }
}

