/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.features;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.IEditorInput;
import org.simantics.NameLabelMode;
import org.simantics.NameLabelUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.workbench.IEditorNamingService;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.IResourceEditorInput2;
import org.simantics.utils.strings.EString;

public class EditorNamingService2
implements IEditorNamingService {
    private static final boolean DEBUG = false;

    public String getName(ReadGraph g, String editorId, IEditorInput in) throws DatabaseException {
        Resource componentType;
        Resource defines;
        if (!(in instanceof IResourceEditorInput)) {
            return "Unsupported input: " + in;
        }
        IResourceEditorInput input = (IResourceEditorInput)in;
        ResourceArray a = input.getResourceArray();
        if (a.isEmpty()) {
            return "(empty input)";
        }
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)g);
        Resource mainInput = a.resources[0];
        NameLabelMode mode = NameLabelUtil.getNameLabelMode((RequestProcessor)g);
        if (g.isInstanceOf(mainInput, dr.Diagram)) {
            if (a.size() == 1) {
                Resource defines2;
                String name = this.nameSingleDiagramInput(g, mainInput, in, mode);
                Resource composite = g.getPossibleObject(mainInput, mr.DiagramToComposite);
                if (composite != null && (defines2 = g.getPossibleObject(composite, sr.Defines)) != null && g.isInstanceOf(defines2, sr.ComponentType) && in instanceof IResourceEditorInput2) {
                    IResourceEditorInput2 in2 = (IResourceEditorInput2)in;
                    String rvi = in2.getRVI();
                    String ctName = NameLabelUtil.modalName((ReadGraph)g, (Resource)defines2, (NameLabelMode)mode);
                    if (rvi == null || rvi.isEmpty()) {
                        return String.valueOf(ctName) + " (Configuration)";
                    }
                    return String.valueOf(name) + " : " + ctName;
                }
                return name;
            }
            return this.namePathInput(g, input, in, mode);
        }
        if (g.isInstanceOf(mainInput, dr.Composite) && (defines = g.getPossibleObject(mainInput, sr.Defines)) != null && g.isInheritedFrom(defines, dr.DefinedElement) && (componentType = g.getPossibleObject(defines, mr.SymbolToComponentType)) != null) {
            String symbolName = NameLabelUtil.modalName((ReadGraph)g, (Resource)defines, (NameLabelMode)mode);
            String cName = NameLabelUtil.modalName((ReadGraph)g, (Resource)componentType, (NameLabelMode)mode);
            return String.valueOf(symbolName) + " (Symbol of " + cName + ")";
        }
        String name = NameLabelUtil.modalName((ReadGraph)g, (Resource)mainInput, (NameLabelMode)mode);
        if (name == null) {
            name = "(no name)";
        }
        return name;
    }

    protected String nameSingleDiagramInput(ReadGraph g, Resource input, IEditorInput in, NameLabelMode mode) throws DatabaseException {
        String compositeName;
        IResourceEditorInput2 in2;
        String rvi;
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)g);
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        if (in instanceof IResourceEditorInput2 && (rvi = (in2 = (IResourceEditorInput2)in).getRVI()) != null && !rvi.isEmpty() && (compositeName = this.getPossibleCompositeName(g, in2, mode)) != null) {
            return compositeName;
        }
        Resource composite = g.getPossibleObject(input, mr.DiagramToComposite);
        if (composite == null) {
            return this.getSafeLabel(g, input, mode);
        }
        Resource defines = g.getPossibleObject(composite, sr.Defines);
        if (defines != null) {
            return this.getSafeLabel(g, defines, mode);
        }
        return this.getSafeLabel(g, composite, mode);
    }

    protected Variable getPossibleConfigurationCompositeVariable(ReadGraph graph, IResourceEditorInput2 in) throws DatabaseException {
        try {
            if (in.getRVI() != null) {
                return in.getVariable(graph);
            }
        }
        catch (DatabaseException databaseException) {}
        return null;
    }

    protected String getPossibleCompositeName(ReadGraph g, IResourceEditorInput2 in, NameLabelMode mode) throws DatabaseException {
        Variable composite = this.getPossibleConfigurationCompositeVariable(g, in);
        return composite == null ? null : NameLabelUtil.modalName((ReadGraph)g, (Variable)composite, (NameLabelMode)mode);
    }

    protected String namePathInput(ReadGraph g, IResourceEditorInput input, IEditorInput in, NameLabelMode mode) throws DatabaseException {
        StringBuilder sb = new StringBuilder();
        Resource composite = input.getResourceArray().resources[1];
        sb.append(this.getSafeLabel(g, composite, mode));
        sb.append(" ");
        this.pathSuffix(g, input.getResourceArray(), mode, 2, sb);
        return sb.toString();
    }

    protected void pathSuffix(ReadGraph g, ResourceArray a, NameLabelMode mode, int dropFromTail, StringBuilder result) throws DatabaseException {
        this.path(g, a, mode, 0, dropFromTail, true, ".", result);
    }

    protected void path(ReadGraph g, ResourceArray a, NameLabelMode mode, int dropFromHead, int dropFromTail, boolean addParenthesis, String separator, StringBuilder result) throws DatabaseException {
        if (a.resources.length > 1) {
            ArrayList<String> pathNames = new ArrayList<String>(a.size() + 1);
            int i = a.resources.length - 1 - dropFromHead;
            while (i >= dropFromTail) {
                String pathElementName = this.truncated(this.getSafeLabel(g, a.resources[i], mode), 256);
                if (pathElementName.contains(separator)) {
                    pathElementName = String.valueOf('\"') + pathElementName + '\"';
                }
                pathNames.add(pathElementName);
                --i;
            }
            this.path(pathNames, addParenthesis, separator, result);
        }
    }

    protected void path(List<String> segments, boolean addParenthesis, String separator, StringBuilder result) throws DatabaseException {
        if (!segments.isEmpty()) {
            if (addParenthesis) {
                result.append("(");
            }
            result.append(EString.implode(segments, (String)separator));
            if (addParenthesis) {
                result.append(')');
            }
        }
    }

    protected String getSafeLabel(ReadGraph graph, Resource r, NameLabelMode mode) throws DatabaseException {
        return NameLabelUtil.modalName((ReadGraph)graph, (Resource)r, (NameLabelMode)mode);
    }

    protected String limitedName(ReadGraph graph, String name, IEditorInput in) throws DatabaseException {
        if (name.length() < 256) {
            return name;
        }
        if (!(in instanceof IResourceEditorInput)) {
            return "Unsupported input: " + in;
        }
        IResourceEditorInput input = (IResourceEditorInput)in;
        return NameUtils.getSafeName((ReadGraph)graph, (Resource)input.getResource());
    }

    protected String truncated(String name, int maxLength) throws DatabaseException {
        if (name.length() <= maxLength) {
            return name;
        }
        return String.valueOf(name.substring(0, Math.max(0, maxLength - 3))) + "...";
    }
}

