/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import gnu.trove.map.hash.TObjectLongHashMap;
import java.util.ArrayDeque;
import org.eclipse.swt.widgets.Display;

public class DisposingPolicy {
    public static final boolean DEBUG = false;
    public static final int MAX_QUEUE_LENGTH = 8;
    public static final long DISPOSE_TIME = 30000L;
    public static final long MIN_DELAY = 200L;
    private volatile int maxQueueLength;
    private ArrayDeque<Runnable> disposerQueue;
    private TObjectLongHashMap<Runnable> disposeTime;
    private Runnable currentlyScheduled = null;
    private Runnable disposeOne = () -> {
        if (!this.disposerQueue.isEmpty()) {
            Runnable runnable = this.disposerQueue.removeFirst();
            this.disposeTime.remove((Object)runnable);
            this.currentlyScheduled = null;
            runnable.run();
            if (!this.disposerQueue.isEmpty()) {
                this.scheduleDispose();
            }
        }
    };

    public DisposingPolicy() {
        this(8);
    }

    public DisposingPolicy(int maxQueueLength) {
        this.maxQueueLength = maxQueueLength;
        this.disposerQueue = new ArrayDeque(maxQueueLength);
        this.disposeTime = new TObjectLongHashMap(maxQueueLength);
    }

    public void setMaxQueueLength(int maxQueueLength) {
        this.maxQueueLength = maxQueueLength;
    }

    private void scheduleDispose() {
        this.currentlyScheduled = this.disposerQueue.peekFirst();
        long delay = Math.max(this.disposeTime.get((Object)this.currentlyScheduled) - System.currentTimeMillis(), 200L);
        Display.getCurrent().timerExec((int)delay, this.disposeOne);
    }

    public void addDisposer(Runnable disposer) {
        if (this.disposeTime.contains((Object)disposer)) {
            return;
        }
        if (this.disposerQueue.size() >= this.maxQueueLength) {
            this.disposeOne.run();
        }
        this.disposerQueue.addLast(disposer);
        this.disposeTime.put((Object)disposer, System.currentTimeMillis() + 30000L);
        if (this.disposerQueue.size() == 1) {
            this.scheduleDispose();
        }
    }

    public void removeDisposer(Runnable disposer) {
        this.disposerQueue.remove(disposer);
        this.disposeTime.remove((Object)disposer);
        if (disposer == this.currentlyScheduled) {
            this.currentlyScheduled = null;
            if (!this.disposerQueue.isEmpty()) {
                this.scheduleDispose();
            }
        }
    }
}

