/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import com.kitfox.svg.SVGCache;
import java.awt.Color;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.simantics.Simantics;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.PossibleAdapter;
import org.simantics.db.common.primitiverequest.PossibleObject;
import org.simantics.db.common.procedure.adapter.ListenerDelegate;
import org.simantics.db.common.procedure.adapter.ListenerSupport;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.common.request.TypeURIs;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.TagUtil;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.combinations.Combinators;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.DiagramTypeUtils;
import org.simantics.diagram.adapter.FlagClassFactory;
import org.simantics.diagram.adapter.GraphToDiagramSynchronizer;
import org.simantics.diagram.adapter.IDiagramLoader;
import org.simantics.diagram.connection.ModelledConnectionAdvisor;
import org.simantics.diagram.handler.ConnectionCommandHandler;
import org.simantics.diagram.handler.CopyPasteHandler;
import org.simantics.diagram.handler.CopyPasteStrategy;
import org.simantics.diagram.handler.DefaultCopyPasteStrategy;
import org.simantics.diagram.handler.DeleteHandler;
import org.simantics.diagram.handler.ExpandSelectionHandler;
import org.simantics.diagram.handler.SimpleElementTransformHandler;
import org.simantics.diagram.layer.ILayersViewPage;
import org.simantics.diagram.participant.ContextUtil;
import org.simantics.diagram.participant.PointerInteractor2;
import org.simantics.diagram.participant.SGFocusParticipant;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.diagram.runtime.RuntimeDiagramManager;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.symbolcontribution.SymbolProviderFactory;
import org.simantics.diagram.synchronization.CopyAdvisor;
import org.simantics.diagram.synchronization.IModifiableSynchronizationContext;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.diagram.ui.SWTPopupMenuParticipant;
import org.simantics.diagram.ui.SWTPopupMenuParticipantAwt;
import org.simantics.diagram.ui.WorkbenchSelectionProvider;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.chassis.AWTChassis;
import org.simantics.g2d.chassis.ICanvasChassis;
import org.simantics.g2d.chassis.IChassisListener;
import org.simantics.g2d.chassis.SWTChassis;
import org.simantics.g2d.connection.IConnectionAdvisor;
import org.simantics.g2d.diagram.DiagramClass;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.impl.Diagram;
import org.simantics.g2d.diagram.participant.DelayedBatchElementPainter;
import org.simantics.g2d.diagram.participant.DiagramParticipant;
import org.simantics.g2d.diagram.participant.ElementInteractor;
import org.simantics.g2d.diagram.participant.ElementPainter;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.TerminalPainter;
import org.simantics.g2d.diagram.participant.ZOrderHandler;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.element.ElementClassProviders;
import org.simantics.g2d.element.ElementClasses;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.IElementClassProvider;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.elementclass.connection.ConnectionClass;
import org.simantics.g2d.page.DiagramDesc;
import org.simantics.g2d.participant.BackgroundPainter;
import org.simantics.g2d.participant.CanvasBoundsParticipant;
import org.simantics.g2d.participant.CanvasGrab;
import org.simantics.g2d.participant.GridPainter;
import org.simantics.g2d.participant.KeyUtil;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.g2d.participant.Notifications;
import org.simantics.g2d.participant.PageBorderParticipant;
import org.simantics.g2d.participant.PanZoomRotateHandler;
import org.simantics.g2d.participant.PointerPainter;
import org.simantics.g2d.participant.RenderingQualityInteractor;
import org.simantics.g2d.participant.RulerPainter;
import org.simantics.g2d.participant.SymbolUtil;
import org.simantics.g2d.participant.TimeParticipant;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.participant.WorkbenchStatusLine;
import org.simantics.g2d.participant.ZoomToAreaHandler;
import org.simantics.g2d.tooltip.TerminalTooltipParticipant;
import org.simantics.g2d.utils.CanvasUtils;
import org.simantics.layer0.utils.triggers.IActivation;
import org.simantics.layer0.utils.triggers.IActivationManager;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.mapping.ComponentCopyAdvisor;
import org.simantics.modeling.mapping.ElementCopyAdvisor;
import org.simantics.modeling.mapping.MappedElementCopyAdvisor;
import org.simantics.modeling.mapping.ModelingSynchronizationHints;
import org.simantics.modeling.ui.diagramEditor.DiagramEditorStates;
import org.simantics.modeling.ui.diagramEditor.DiagramLayersPage;
import org.simantics.modeling.ui.diagramEditor.DiagramOutlinePage;
import org.simantics.modeling.ui.diagramEditor.DiagramViewerLoadJob;
import org.simantics.modeling.ui.diagramEditor.EditorState;
import org.simantics.modeling.ui.diagramEditor.HasDiagramSourceListener;
import org.simantics.modeling.ui.diagramEditor.Messages;
import org.simantics.modeling.ui.diagramEditor.PopulateElementDropParticipant;
import org.simantics.modeling.ui.diagramEditor.PopulateElementMonitorDropParticipant;
import org.simantics.modeling.ui.diagramEditor.handlers.LinkBrowsingHandler;
import org.simantics.modeling.ui.diagramEditor.handlers.StructuralBrowsingHandler;
import org.simantics.modeling.ui.preferences.DiagramPreferenceUtil;
import org.simantics.modeling.ui.preferences.DiagramPreferences;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.snap.GridSnapAdvisor;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.selectionview.StandardPropertyPage;
import org.simantics.structural2.modelingRules.IModelingRules;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.jobs.SessionGarbageCollectorJob;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.IResourceEditorInput2;
import org.simantics.ui.workbench.TitleRequest;
import org.simantics.ui.workbench.TitleUpdater;
import org.simantics.ui.workbench.ToolTipRequest;
import org.simantics.ui.workbench.editor.input.InputValidationCombinators;
import org.simantics.utils.DataContainer;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SWTThread;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;

public class DiagramViewer
implements ListenerSupport,
IAdaptable {
    public static final String DIAGRAMMING_CONTEXT = "org.simantics.modeling.ui.diagramming";
    private static final String PREFERENCE_VIRTUAL_GRAPH = "preferences";
    private static final boolean PROFILE = false;
    ParametrizedRead<IResourceEditorInput, Boolean> INPUT_VALIDATOR = Combinators.compose((ParametrizedRead)InputValidationCombinators.or((ParametrizedRead)Combinators.compose((ParametrizedRead)InputValidationCombinators.hasURI(), (ParametrizedRead)InputValidationCombinators.partialFunction((String)"http://www.simantics.org/Modeling-1.2/DiagramToComposite")), (ParametrizedRead)Combinators.compose((ParametrizedRead)InputValidationCombinators.hasURI(), (ParametrizedRead)Combinators.compose((ParametrizedRead)InputValidationCombinators.partialFunction((String)"http://www.simantics.org/Structural-1.2/Defines"), (ParametrizedRead)InputValidationCombinators.partialFunction((String)"http://www.simantics.org/Modeling-1.2/DiagramToComposite")))), (ParametrizedRead)InputValidationCombinators.extractInputResource());
    protected EditorState editorState;
    protected boolean disposed = false;
    protected IThreadWorkQueue swt;
    protected IStatusLineManager statusLineManager;
    protected Display display;
    protected LocalResourceManager resourceManager;
    protected SWTChassis c;
    protected IDiagram sourceDiagram;
    protected DataContainer<IDiagram> sourceDiagramContainer;
    protected CanvasContext canvasContext;
    protected ISessionContextProvider sessionContextProvider;
    protected ISessionContext sessionContext;
    protected Resource diagramResource;
    protected GraphToDiagramSynchronizer synchronizer;
    protected IActivation activation;
    protected ContextUtil contextUtil;
    protected SWTPopupMenuParticipant popupMenuParticipant;
    protected DiagramPreferences diagramPreferences;
    protected DiagramDesc diagramDesc;
    protected GridSnapAdvisor snapAdvisor;
    private RuntimeDiagramManager runtimeDiagramManager;
    private Resource runtimeDiagramResourceCache;
    private HasDiagramSourceListener hasDiagramSourceListener;
    protected WorkbenchSelectionProvider selectionProvider;
    public static Set<String> defaultPropertyBrowseContexts = Collections.singleton("http://www.simantics.org/Project-1.2/ProjectBrowseContext");
    private boolean firstFocus = true;
    IHintListener canvasHintListener = new HintListenerAdapter(){

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            if (key == GridPainter.KEY_GRID_ENABLED) {
                boolean v = Boolean.TRUE.equals(newValue);
                if (DiagramViewer.this.diagramDesc.isGridVisible() != v) {
                    DiagramViewer.this.setGlobalPreference("http://www.simantics.org/Diagram-2.2/DisplayGrid", v);
                }
            } else if (key == RulerPainter.KEY_RULER_ENABLED) {
                boolean v = Boolean.TRUE.equals(newValue);
                if (DiagramViewer.this.diagramDesc.isRulerVisible() != v) {
                    DiagramViewer.this.setGlobalPreference("http://www.simantics.org/Diagram-2.2/DisplayRuler", v);
                }
            }
        }
    };
    private IWorkbenchPartSite partSite;
    private DiagramViewerHost host;
    private IEditorInput editorInput = null;

    protected Resource getRuntimeFromManager() {
        RuntimeDiagramManager rtdm = this.runtimeDiagramManager;
        return rtdm == null ? null : rtdm.getRuntimeDiagram();
    }

    public Resource getRuntime() {
        if (this.runtimeDiagramResourceCache != null) {
            return this.runtimeDiagramResourceCache;
        }
        this.runtimeDiagramResourceCache = this.getRuntimeFromManager();
        return this.runtimeDiagramResourceCache;
    }

    public ParametrizedRead<IResourceEditorInput, Boolean> getInputValidator() {
        return this.INPUT_VALIDATOR;
    }

    protected void addDropParticipants(ICanvasContext ctx) {
        ctx.getDefaultHintContext().setHint(Hints.KEY_ALLOWED_DRAG_ACTIONS, (Object)1);
        ctx.add((Object)new PopulateElementDropParticipant(this.synchronizer, this.getSite()));
        ctx.add((Object)new PopulateElementMonitorDropParticipant(this.synchronizer, 0.5, 0.5));
    }

    protected CopyPasteStrategy getCopyPasteStrategy() {
        try {
            CopyPasteStrategy cpStrategy = (CopyPasteStrategy)Simantics.getSession().syncRequest((Read)new PossibleAdapter(this.getInputResource(), CopyPasteStrategy.class));
            if (cpStrategy != null) {
                return cpStrategy;
            }
        }
        catch (DatabaseException databaseException) {}
        return this.getDefaultCopyPasteStrategy();
    }

    protected CopyPasteStrategy getDefaultCopyPasteStrategy() {
        return new DefaultCopyPasteStrategy();
    }

    protected CopyAdvisor getCopyAdvisor() {
        try {
            CopyAdvisor advisor = (CopyAdvisor)Simantics.getSession().syncRequest((Read)new PossibleAdapter(this.getInputResource(), CopyAdvisor.class));
            if (advisor != null) {
                return advisor;
            }
        }
        catch (DatabaseException databaseException) {}
        return new MappedElementCopyAdvisor((CopyAdvisor)new ElementCopyAdvisor(), (CopyAdvisor)new ComponentCopyAdvisor());
    }

    protected void addKeyBindingParticipants(CanvasContext ctx) {
        ctx.add((Object)new DeleteHandler(this.statusLineManager));
        ctx.add((Object)new CopyPasteHandler(this.getCopyPasteStrategy(), this.statusLineManager).setWorkbenchSite((IWorkbenchPartSite)this.getEditorSite()));
        ctx.add((Object)new ConnectionCommandHandler());
    }

    protected void addPopupmenu(ICanvasContext ctx) {
        ctx.add((Object)this.popupMenuParticipant);
    }

    protected void addWorkbenchSelectionProvider(ICanvasContext ctx) {
        if (this.selectionProvider != null) {
            ctx.add((Object)this.selectionProvider);
        }
    }

    protected void addViewManipulationParticipants(CanvasContext ctx) {
        ctx.add((Object)new PanZoomRotateHandler());
        ctx.add((Object)new ZoomToAreaHandler());
    }

    protected void addDiagramParticipants(ICanvasContext ctx) {
        ctx.add((Object)new ZOrderHandler());
        ctx.add((Object)this.getPointerInteractor());
        ctx.add((Object)new ElementInteractor());
        ctx.add((Object)new Selection());
        ctx.add((Object)new DiagramParticipant());
        ctx.add((Object)new ElementPainter());
        ctx.add((Object)new TerminalTooltipParticipant());
    }

    protected void addPainterParticipants(ICanvasContext ctx) {
        ctx.add((Object)new RenderingQualityInteractor());
        ctx.add((Object)new TerminalPainter(true, true, false, true));
        ctx.add((Object)new DelayedBatchElementPainter(PickRequest.PickFilter.FILTER_MONITORS, 500L, TimeUnit.MILLISECONDS));
    }

    protected void addStructureParticipants(ICanvasContext ctx) {
        this.addWorkbenchSelectionProvider(ctx);
        ctx.add((Object)new StructuralBrowsingHandler(this.getSite(), this.sessionContext, this.getResourceInput2()));
        ctx.add((Object)new LinkBrowsingHandler(this.getSite(), this, this.sessionContext));
    }

    protected void addOtherParticipants(CanvasContext ctx) {
    }

    protected Set<String> getPropertyPageContexts() {
        try {
            return BrowseContext.getBrowseContextClosure((RequestProcessor)Simantics.getSession(), defaultPropertyBrowseContexts);
        }
        catch (DatabaseException e) {
            ExceptionUtils.logAndShowError((String)Messages.DiagramViewer_FailedtoLoadModeled, (Throwable)e);
            return defaultPropertyBrowseContexts;
        }
    }

    protected IPropertyPage createPropertyPage(IWorkbenchPartSite site, Set<String> contexts) {
        return new StandardPropertyPage(site, contexts);
    }

    protected String getPopupId() {
        return "#ModelingDiagramPopup";
    }

    protected void getPreferences() {
        this.diagramPreferences = DiagramPreferenceUtil.getPreferences();
    }

    protected void initSession() {
        this.sessionContextProvider = Simantics.getSessionContextProvider();
        this.sessionContext = this.sessionContextProvider.getSessionContext();
    }

    protected void readNames() {
        String name = this.getEditorInput().getName();
        this.host.doSetPartName(name);
        this.host.doSetTitleToolTip(name);
    }

    protected void createChassis(Composite parent) {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.c = new SWTChassis(parent, 0);
        Object task = DiagramViewer.BEGIN("DV.precreateParticipants");
        this.createCustomParticipants();
        DiagramViewer.END(task);
        this.c.populate(component -> {
            if (!this.disposed) {
                this.c.addChassisListener((IChassisListener)new ChassisListener());
                this.initializeCanvas();
            }
        });
    }

    protected void beforeSetCanvasContext(ICanvasContext canvasContext2) {
    }

    protected void setCanvasContext(ICanvasContext context) {
        this.c.getAWTComponent().setCanvasContext((ICanvasContext)this.canvasContext);
        this.swt.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!DiagramViewer.this.c.isDisposed()) {
                    DiagramViewer.this.c.setCanvasContext((ICanvasContext)DiagramViewer.this.canvasContext);
                }
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        this.swt = SWTThread.getThreadAccess((Display)this.display);
        this.statusLineManager = this.getEditorSite().getActionBars().getStatusLineManager();
        Object task = DiagramViewer.BEGIN("DV.initSession");
        this.initSession();
        DiagramViewer.END(task);
        this.diagramResource = this.getInputResource();
        this.readNames();
        this.getPreferences();
        try {
            this.runtimeDiagramManager = RuntimeDiagramManager.track((Session)this.sessionContext.getSession(), (Resource)this.diagramResource, (IEditorInput)this.getEditorInput(), (ListenerSupport)this);
            IThreadWorkQueue thread = AWTThread.getThreadAccess();
            this.canvasContext = new CanvasContext(thread);
            this.canvasContext.setLocked(true);
            task = DiagramViewer.BEGIN("DV.createChassis");
            this.createChassis(parent);
            DiagramViewer.END(task);
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
    }

    protected void createCustomParticipants() {
        this.popupMenuParticipant = SimanticsUI.isLinuxGTK() ? new SWTPopupMenuParticipantAwt(this.getSite(), (Control)this.c, this.display, this.getPopupId()) : new SWTPopupMenuParticipant(this.getSite(), (Control)this.c, this.display, this.getPopupId());
    }

    protected void initializeCanvas() {
        Object canvasInit = DiagramViewer.BEGIN("DV.canvasInitialization");
        Object task = DiagramViewer.BEGIN("DV.createViewerCanvas");
        this.initializeCanvasContext(this.canvasContext);
        DiagramViewer.END(task);
        this.beforeSetCanvasContext((ICanvasContext)this.canvasContext);
        this.canvasContext.getDefaultHintContext().setHint(DiagramHints.KEY_DIAGRAM, (Object)Diagram.spawnNew((DiagramClass)DiagramClass.DEFAULT));
        this.canvasContext.getHintStack().addKeyHintListener(GridPainter.KEY_GRID_ENABLED, this.canvasHintListener);
        this.canvasContext.getHintStack().addKeyHintListener(RulerPainter.KEY_RULER_ENABLED, this.canvasHintListener);
        task = DiagramViewer.BEGIN("DV.setCanvasContext");
        this.setCanvasContext((ICanvasContext)this.canvasContext);
        DiagramViewer.END(task);
        DiagramViewerLoadJob loadJob = new DiagramViewerLoadJob(this);
        loadJob.schedule();
        DiagramViewer.END(canvasInit);
    }

    protected void activateUiContexts(ContextUtil util) {
        util.activate(DIAGRAMMING_CONTEXT);
    }

    protected void performActivation(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DiagramViewer_MonitorActivateMapping, (int)100);
        IActivationManager activationManager = (IActivationManager)this.sessionContext.getSession().peekService(IActivationManager.class);
        if (activationManager != null) {
            this.activation = activationManager.activate(this.diagramResource);
        }
        progress.worked(100);
    }

    protected void onCreated() {
    }

    protected void scheduleZoomToFit(IDiagram diagram) {
        if (diagram == null) {
            throw new IllegalStateException("diagram is null");
        }
        CanvasUtils.scheduleZoomToFit((IThreadWorkQueue)this.swt, () -> this.disposed, (ICanvasContext)this.canvasContext, (IDiagram)diagram);
    }

    protected void fillInitialDiagramHints(Resource diagram, IHintContext initialHints) throws DatabaseException {
        IModelingRules modelingRules = (IModelingRules)this.sessionContext.getSession().syncRequest(DiagramRequests.getModelingRules((Resource)diagram, null));
        if (modelingRules != null) {
            initialHints.setHint(DiagramModelHints.KEY_MODELING_RULES, (Object)modelingRules);
            initialHints.setHint(DiagramHints.CONNECTION_ADVISOR, (Object)this.getConnectionAdvisor(modelingRules, this.sessionContext.getSession()));
        }
        initialHints.setHint(SynchronizationHints.COPY_ADVISOR, (Object)this.getCopyAdvisor());
        initialHints.setHint(DiagramHints.KEY_USE_CONNECTION_FLAGS, (Object)Boolean.TRUE);
        initialHints.setHint(DiagramHints.KEY_ALLOW_CONNECTION_BRANCHING, (Object)Boolean.TRUE);
        initialHints.setHint(DiagramHints.KEY_ALLOW_ROUTE_POINTS, (Object)Boolean.TRUE);
    }

    protected IDiagram loadDiagram(IProgressMonitor monitor, Resource r) throws DatabaseException {
        HintContext initialHints = new HintContext();
        this.fillInitialDiagramHints(r, (IHintContext)initialHints);
        IDiagram d = this.loadDiagram(monitor, r, (IHintContext)initialHints);
        return d;
    }

    protected IDiagram loadDiagram(IProgressMonitor monitor, Resource diagram, IHintContext initialHints) throws DatabaseException {
        RuntimeDiagramManager rtdm = this.runtimeDiagramManager;
        Resource runtimeDiagram = rtdm != null ? rtdm.getRuntimeDiagram() : null;
        GraphToDiagramSynchronizer loader = this.synchronizer;
        if (rtdm == null || runtimeDiagram == null || loader == null) {
            return null;
        }
        IDiagram d = (IDiagram)this.sessionContext.getSession().syncRequest(arg_0 -> this.lambda$2(monitor, diagram, runtimeDiagram, (IDiagramLoader)loader, initialHints, arg_0));
        return d;
    }

    protected void beforeSetDiagram(IDiagram diagram) {
    }

    protected PointerInteractor getPointerInteractor() {
        return new PointerInteractor2(true, true, true, false, true, false, this.synchronizer.getElementClassProvider());
    }

    protected IConnectionAdvisor getConnectionAdvisor(IModelingRules modelingRules, Session session) {
        return new ModelledConnectionAdvisor(modelingRules, this.sessionContext.getSession());
    }

    protected GraphToDiagramSynchronizer createSynchronizer(final ICanvasContext ctx, ISessionContext sessionContext) {
        try {
            return (GraphToDiagramSynchronizer)sessionContext.getSession().syncRequest((Read)new Read<GraphToDiagramSynchronizer>(){

                public GraphToDiagramSynchronizer perform(ReadGraph graph) throws DatabaseException {
                    GraphToDiagramSynchronizer sync = new GraphToDiagramSynchronizer((RequestProcessor)graph, ctx, DiagramViewer.this.createElementClassProvider(graph));
                    DiagramViewer.this.initializeSynchronizationContext(graph, (IModifiableSynchronizationContext)sync);
                    return sync;
                }
            });
        }
        catch (DatabaseException e) {
            throw new UnsupportedOperationException("Failed to initialize data model synchronizer", e);
        }
    }

    protected void initializeSynchronizationContext(ReadGraph graph, IModifiableSynchronizationContext context) {
        context.set(ModelingSynchronizationHints.MODELING_RESOURCE, (Object)ModelingResources.getInstance((ReadGraph)graph));
    }

    protected IElementClassProvider createElementClassProvider(ReadGraph graph) {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        return ElementClassProviders.mappedProvider((Object[])new Object[]{ElementClasses.CONNECTION, ConnectionClass.CLASS.newClassWith(new ElementHandler[]{new StaticObjectAdapter((Object)dr.RouteGraphConnection)}), ElementClasses.FLAG, FlagClassFactory.createFlagClass((Resource)dr.Flag, (Resource)dr.Flag_Terminal)});
    }

    protected SimpleElementTransformHandler getTransformHandler() {
        return new SimpleElementTransformHandler(true, true, true);
    }

    public void initializeCanvasContext(CanvasContext ctx) {
        IHintContext h = ctx.getDefaultHintContext();
        h.setHint(Hints.KEY_DISABLE_PAINTING, (Object)Boolean.TRUE);
        Object task = DiagramViewer.BEGIN("createSynchronizer");
        this.synchronizer = this.createSynchronizer((ICanvasContext)ctx, this.sessionContext);
        DiagramViewer.END(task);
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        this.contextUtil = new ContextUtil(contextService, this.swt);
        ctx.add((Object)new TransformUtil());
        ctx.add((Object)new MouseUtil());
        ctx.add((Object)new KeyUtil());
        ctx.add((Object)this.contextUtil);
        ctx.add((Object)new WorkbenchStatusLine(this.statusLineManager));
        ctx.add((Object)new CanvasGrab());
        ctx.add((Object)new SymbolUtil());
        ctx.add((Object)new TimeParticipant());
        ctx.add((Object)new CanvasBoundsParticipant());
        ctx.add((Object)new Notifications());
        ctx.add((Object)new SGFocusParticipant(this.c, DIAGRAMMING_CONTEXT));
        h.setHint(PointerPainter.KEY_PAINT_POINTER, (Object)true);
        this.addViewManipulationParticipants(ctx);
        ctx.add((Object)this.getTransformHandler());
        ctx.add((Object)new ExpandSelectionHandler(this.getEditorSite().getActionBars().getStatusLineManager()));
        this.addKeyBindingParticipants(ctx);
        this.addGridRulerBackgroundParticipants(ctx);
        h.setHint(Hints.KEY_DISPLAY_PAGE, this.diagramPreferences.get("page.display.size"));
        h.setHint(Hints.KEY_DISPLAY_MARGINS, this.diagramPreferences.get("page.display.margins"));
        ctx.add((Object)new PageBorderParticipant());
        h.setHint(Hints.KEY_GRID_COLOR, (Object)new Color(0.9f, 0.9f, 0.9f));
        h.setHint(Hints.KEY_BACKGROUND_COLOR, (Object)Color.WHITE);
        h.setHint(RulerPainter.KEY_RULER_BACKGROUND_COLOR, (Object)new Color(0.9f, 0.9f, 0.9f, 0.75f));
        h.setHint(RulerPainter.KEY_RULER_TEXT_COLOR, (Object)Color.BLACK);
        this.addDiagramParticipants((ICanvasContext)ctx);
        this.addPainterParticipants((ICanvasContext)ctx);
        this.addDropParticipants((ICanvasContext)ctx);
        h.setHint(ElementPainter.KEY_SELECTION_FRAME_COLOR, (Object)Color.MAGENTA);
        h.setHint(Hints.KEY_TOOL, (Object)Hints.POINTERTOOL);
        h.setHint(PanZoomRotateHandler.KEY_ZOOM_IN_LIMIT, (Object)100000.0);
        h.setHint(PanZoomRotateHandler.KEY_ZOOM_OUT_LIMIT, (Object)10.0);
        Double snapResolution = (Double)this.diagramPreferences.get("grid.size");
        this.snapAdvisor = new GridSnapAdvisor(snapResolution.doubleValue());
        h.setHint(DiagramHints.SNAP_ADVISOR, (Object)this.snapAdvisor);
        h.setHint(GridPainter.KEY_GRID_SIZE, (Object)snapResolution);
        h.setHint(GridPainter.KEY_GRID_ENABLED, (Object)Boolean.FALSE);
        this.addStructureParticipants((ICanvasContext)ctx);
        this.addPopupmenu((ICanvasContext)ctx);
        this.loadPageSettings((ICanvasContext)ctx);
        this.addOtherParticipants(ctx);
        ctx.assertParticipantDependencies();
        ctx.setLocked(false);
    }

    protected void addGridRulerBackgroundParticipants(CanvasContext ctx) {
        ctx.add((Object)new GridPainter());
        ctx.add((Object)new RulerPainter());
        ctx.add((Object)new BackgroundPainter());
    }

    protected void loadPageSettings(ICanvasContext ctx) {
        DiagramDesc diagramDesc = null;
        if (this.diagramResource != null) {
            try {
                diagramDesc = (DiagramDesc)this.sessionContext.getSession().syncRequest(DiagramRequests.getDiagramDesc((Resource)this.diagramResource));
            }
            catch (DatabaseException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
        }
        if (diagramDesc == null) {
            final DiagramDesc desc = diagramDesc = this.diagramPreferences.getDiagramDesc();
            this.sessionContext.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    if (graph.isImmutable(DiagramViewer.this.diagramResource)) {
                        return;
                    }
                    CommonDBUtils.selectClusterSet((WriteGraph)graph, (Resource)DiagramViewer.this.diagramResource);
                    DiagramGraphUtil.setDiagramDesc((WriteGraph)graph, (Resource)DiagramViewer.this.diagramResource, (DiagramDesc)desc);
                }
            }, parameter -> {
                if (parameter != null) {
                    ErrorLogger.defaultLogError((String)"Failed to write default diagram page description to database, see exception for details", (Throwable)parameter);
                }
            });
        }
        this.setDiagramDesc(ctx, diagramDesc);
        this.sessionContext.getSession().asyncRequest(DiagramRequests.getDiagramDesc((Resource)this.diagramResource), (Listener)new ListenerDelegate<DiagramDesc>((ListenerSupport)this){

            public void execute(final DiagramDesc result) {
                if (result != null && DiagramViewer.this.canvasContext != null) {
                    ThreadUtils.asyncExec((IThreadWorkQueue)DiagramViewer.this.canvasContext.getThreadAccess(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).DiagramViewer.this.disposed) {
                                DiagramViewer.this.setDiagramDesc((ICanvasContext)(this).DiagramViewer.this.canvasContext, result);
                            }
                        }
                    });
                }
            }
        });
    }

    protected void setDiagramDesc(ICanvasContext ctx, DiagramDesc diagramDesc) {
        if (diagramDesc == null) {
            throw new NullPointerException("null diagram desc");
        }
        if (diagramDesc.equals((Object)this.diagramDesc)) {
            return;
        }
        this.diagramDesc = diagramDesc;
        IHintContext hints = ctx.getDefaultHintContext();
        hints.setHint(Hints.KEY_PAGE_DESC, (Object)diagramDesc.getPageDesc());
        hints.setHint(Hints.KEY_DISPLAY_PAGE, (Object)diagramDesc.isPageBordersVisible());
        hints.setHint(Hints.KEY_DISPLAY_MARGINS, (Object)diagramDesc.isMarginsVisible());
        hints.setHint(GridPainter.KEY_GRID_ENABLED, (Object)diagramDesc.isGridVisible());
        hints.setHint(RulerPainter.KEY_RULER_ENABLED, (Object)diagramDesc.isRulerVisible());
        this.snapAdvisor.setResolution(diagramDesc.getGridSize());
        hints.setHint(GridPainter.KEY_GRID_SIZE, (Object)diagramDesc.getGridSize());
    }

    protected void applyEditorState(EditorState state, ICanvasContext ctx) {
        IDiagram diagram = (IDiagram)ctx.getHintStack().getHint(DiagramHints.KEY_DIAGRAM);
        if (state.viewTransform != null && state.viewTransform.getDeterminant() != 0.0) {
            for (PanZoomRotateHandler h : ctx.getItemsByClass(PanZoomRotateHandler.class)) {
                h.setTransform(state.viewTransform);
            }
        }
        if (diagram != null) {
            if (state.viewTransform != null) {
                diagram.removeHint(DiagramHints.KEY_INITIAL_ZOOM_TO_FIT);
            }
            if (state.toolMode != null) {
                ctx.getDefaultHintContext().setHint(Hints.KEY_TOOL, (Object)state.toToolMode());
            } else {
                ctx.getDefaultHintContext().setHint(Hints.KEY_TOOL, (Object)Hints.POINTERTOOL);
            }
            Set<IElement> selected = DiagramEditorStates.toElements(state.selection, diagram);
            if (!selected.isEmpty()) {
                for (Selection s : ctx.getItemsByClass(Selection.class)) {
                    s.setSelection(0, selected);
                }
            }
        }
    }

    protected EditorState getSavedEditorState(ICanvasContext ctx) {
        return DiagramEditorStates.toEditorState(ctx, true, true, true);
    }

    protected void saveEditorState(ICanvasContext ctx) {
        DiagramEditorStates.saveEditorState(PREFERENCE_VIRTUAL_GRAPH, this.diagramResource, this.getSavedEditorState(ctx), (ListenerSupport)this);
    }

    public void setFocus() {
        if (this.c != null) {
            this.c.setFocus();
            if (this.firstFocus) {
                this.firstFocus = false;
                this.firstTimeSetFocus();
            }
        }
    }

    protected void firstTimeSetFocus() {
    }

    public void dispose() {
        if (this.contextUtil != null) {
            this.contextUtil.deactivateAll();
        }
        this.disposed = true;
        if (this.hasDiagramSourceListener != null) {
            this.hasDiagramSourceListener.dispose();
            this.hasDiagramSourceListener = null;
        }
        if (this.activation != null) {
            this.activation.deactivate();
            this.activation = null;
        }
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
    }

    protected Resource getInputResource() {
        return this.getResourceInput().getResource();
    }

    public IResourceEditorInput getResourceInput() {
        return (IResourceEditorInput)this.getEditorInput();
    }

    public IResourceEditorInput2 getResourceInput2() {
        return (IResourceEditorInput2)this.getEditorInput();
    }

    public void init(DiagramViewerHost _host, IEditorSite site, IEditorInput input, DataContainer<IDiagram> diagramContainer, WorkbenchSelectionProvider selectionProvider) {
        if (!(input instanceof IResourceEditorInput)) {
            throw new RuntimeException("Invalid input: must be IResourceEditorInput");
        }
        this.setHost(_host);
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.sourceDiagramContainer = diagramContainer;
        this.selectionProvider = selectionProvider;
        this.host.doSetPartName(this.getEditorInput().getName());
        Session session = Simantics.peekSession();
        if (session != null) {
            Supplier<Boolean> disposedCallback = () -> this.disposed;
            session.asyncRequest((Read)new TitleRequest(site.getId(), this.getResourceInput()), (Listener)new TitleUpdater(site.getShell().getDisplay(), this.host::doSetPartName, disposedCallback));
            session.asyncRequest((Read)new ToolTipRequest(site.getId(), this.getResourceInput()), (Listener)new TitleUpdater(site.getShell().getDisplay(), this.host::doSetTitleToolTip, disposedCallback));
        }
        try {
            this.editorState = DiagramEditorStates.readEditorState(this.getInputResource());
        }
        catch (DatabaseException e) {
            this.exception(e);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertyPage.class) {
            return (T)this.createPropertyPage(this.getSite(), this.getPropertyPageContexts());
        }
        if (adapter == SymbolProviderFactory.class) {
            try {
                return (T)DiagramTypeUtils.readSymbolProviderFactory((RequestProcessor)this.sessionContext.getSession(), (Resource)this.diagramResource);
            }
            catch (DatabaseException e) {
                ErrorLogger.defaultLogError((String)(this.getClass() + " failed to adapt to SymbolProviderFactory, see exception for details."), (Throwable)e);
                return null;
            }
        }
        if (adapter == IContentOutlinePage.class) {
            return (T)((Object)new DiagramOutlinePage(this.sessionContextProvider, this.getResourceInput2()));
        }
        if (adapter == ILayersViewPage.class) {
            return (T)((Object)new DiagramLayersPage(this.sourceDiagram, (ICanvasContext)this.canvasContext));
        }
        if (adapter == ICanvasContext.class) {
            return (T)this.canvasContext;
        }
        if (adapter == INode.class) {
            G2DParentNode node;
            if (this.canvasContext != null && (node = this.canvasContext.getCanvasNode()) != null) {
                return (T)NodeUtil.getRootNode((INode)node);
            }
            return null;
        }
        if (adapter == IDiagram.class) {
            return (T)this.sourceDiagram;
        }
        if (adapter == Session.class) {
            return (T)this.sessionContext.getSession();
        }
        if (adapter == RuntimeDiagramManager.class) {
            return (T)this.runtimeDiagramManager;
        }
        if (adapter == Resource.class) {
            return (T)this.getRuntime();
        }
        if (adapter == ICanvasChassis.class) {
            return (T)this.c;
        }
        return null;
    }

    protected static Object BEGIN(String name) {
        return null;
    }

    protected static void END(Object task) {
    }

    public void exception(Throwable t) {
        ErrorLogger.defaultLogError((Throwable)t);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    protected void collectGarbage() {
        SessionGarbageCollectorJob.getInstance().schedule(0L);
        AWTThread.getThreadAccess().asyncExec(new Runnable(){

            @Override
            public void run() {
                SVGCache.getSVGUniverse().clearUnreferenced();
            }
        });
    }

    private <T> void setGlobalPreference(String preferenceURI, boolean value) {
        TagUtil.execute((Session)Simantics.getSession(), (String)PREFERENCE_VIRTUAL_GRAPH, (String)preferenceURI, (boolean)value, (Resource[])new Resource[]{Simantics.getProjectResource()});
    }

    public IWorkbenchPartSite getSite() {
        return this.partSite;
    }

    public IEditorSite getEditorSite() {
        return (IEditorSite)this.getSite();
    }

    public IEditorInput getEditorInput() {
        return this.editorInput;
    }

    protected void setHost(DiagramViewerHost host) {
        this.host = host;
    }

    protected void setSite(IWorkbenchPartSite site) {
        this.partSite = site;
    }

    protected void setInput(IEditorInput input) {
        Assert.isLegal((input != null ? 1 : 0) != 0);
        this.editorInput = input;
    }

    public Composite getComposite() {
        return this.c;
    }

    private /* synthetic */ IDiagram lambda$2(IProgressMonitor iProgressMonitor, Resource resource, Resource resource2, IDiagramLoader iDiagramLoader, IHintContext iHintContext, ReadGraph graph) throws DatabaseException {
        IDiagram result = (IDiagram)DiagramRequests.loadDiagram((IProgressMonitor)iProgressMonitor, (Resource)this.getResourceInput2().getModel(null), (Resource)resource, (Resource)resource2, null, (IDiagramLoader)iDiagramLoader, (IHintObservable)iHintContext).perform(graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource composite = graph.getPossibleObject(resource, MOD.DiagramToComposite);
        result.setHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE_TYPE_URIS, graph.syncRequest((Read)new TypeURIs(resource)));
        result.setHint(DiagramModelHints.KEY_MAPPED_COMPOSITE_RESOURCE_TYPE_URIS, composite != null ? graph.syncRequest((Read)new TypeURIs(composite)) : Collections.emptySet());
        this.hasDiagramSourceListener = new HasDiagramSourceListener(this.sourceDiagramContainer);
        Resource diagramSource = (Resource)graph.syncRequest((AsyncRead)new PossibleObject(resource, MOD.HasDiagramSource), (Listener)this.hasDiagramSourceListener);
        ElementUtils.setOrRemoveHint((IHintContext)result, (IHintContext.Key)DiagramModelHints.KEY_HAS_DIAGRAM_SOURCE, (Object)diagramSource);
        return result;
    }

    class ChassisListener
    implements IChassisListener {
        ChassisListener() {
        }

        public void chassisClosed(ICanvasChassis sender) {
            CanvasContext ctx = DiagramViewer.this.canvasContext;
            ThreadUtils.asyncExec((IThreadWorkQueue)ctx.getThreadAccess(), (Runnable)new Runnable((ICanvasContext)ctx){
                private final /* synthetic */ ICanvasContext val$ctx;
                {
                    this.val$ctx = iCanvasContext;
                }

                @Override
                public void run() {
                    if (this.val$ctx != null) {
                        DiagramViewer.this.saveEditorState(this.val$ctx);
                        this.val$ctx.getHintStack().removeKeyHintListener(GridPainter.KEY_GRID_ENABLED, ((ChassisListener)ChassisListener.this).DiagramViewer.this.canvasHintListener);
                        this.val$ctx.getHintStack().removeKeyHintListener(RulerPainter.KEY_RULER_ENABLED, ((ChassisListener)ChassisListener.this).DiagramViewer.this.canvasHintListener);
                        AWTChassis awtChassis = ((ChassisListener)ChassisListener.this).DiagramViewer.this.c.getAWTComponent();
                        if (awtChassis != null) {
                            awtChassis.setCanvasContext(null);
                        }
                        this.val$ctx.dispose();
                    }
                    if (((ChassisListener)ChassisListener.this).DiagramViewer.this.sourceDiagramContainer != null) {
                        ((ChassisListener)ChassisListener.this).DiagramViewer.this.sourceDiagramContainer.set(null);
                        ((ChassisListener)ChassisListener.this).DiagramViewer.this.sourceDiagramContainer = null;
                    }
                    if (((ChassisListener)ChassisListener.this).DiagramViewer.this.sourceDiagram != null) {
                        ((ChassisListener)ChassisListener.this).DiagramViewer.this.sourceDiagram.dispose();
                    }
                    if (((ChassisListener)ChassisListener.this).DiagramViewer.this.synchronizer != null) {
                        ((ChassisListener)ChassisListener.this).DiagramViewer.this.synchronizer.dispose();
                        ((ChassisListener)ChassisListener.this).DiagramViewer.this.synchronizer = null;
                    }
                    if (DiagramViewer.this.runtimeDiagramManager != null) {
                        DiagramViewer.this.runtimeDiagramManager.dispose();
                        DiagramViewer.this.runtimeDiagramManager = null;
                    }
                }
            });
            DiagramViewer.this.c.removeChassisListener((IChassisListener)this);
        }
    }

    public static interface DiagramViewerHost {
        public void doSetPartName(String var1);

        public void doSetTitleToolTip(String var1);
    }
}

