/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram.monitor;

import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.common.color.Color;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.EvaluatingListener;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.adapter.SyncElementFactory;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.elements.MonitorClass;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.CompositeHintSynchronizer;
import org.simantics.diagram.synchronization.IHintSynchronizer;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.ElementLoader;
import org.simantics.diagram.synchronization.graph.MonitorSynchronizer;
import org.simantics.diagram.synchronization.graph.TransformSynchronizer;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.handler.Relationship;
import org.simantics.g2d.diagram.handler.RelationshipHandler;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.TextEditor;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.utils.Alignment;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.diagram.monitor.MonitorListener;
import org.simantics.modeling.ui.diagram.monitor.MonitorVariable;
import org.simantics.modeling.ui.diagram.monitor.MonitorVariableValueRequest;
import org.simantics.modeling.ui.diagram.monitor.MonitorVariableWrite;
import org.simantics.modeling.ui.diagram.monitor.ResolveMonitorVariable;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.ui.colors.Colors;
import org.simantics.ui.fonts.FontDescriptor;
import org.simantics.ui.fonts.Fonts;
import org.simantics.utils.datastructures.hints.IHintContext;

public class MonitorClassFactory2
extends SyncElementFactory {
    private static final IHintContext.Key KEY_VARIABLE_LISTENER = new IHintContext.KeyOf(MonitorListener.class, "MONITOR_VARIABLE_LISTENER");
    private static final String CLASS_ID = "Monitor";
    private static final IHintSynchronizer HINT_SYNCHRONIZER = new CompositeHintSynchronizer(new IHintSynchronizer[]{MonitorSynchronizer.INSTANCE, TransformSynchronizer.INSTANCE});

    public static ElementClass createMonitorClass(Resource elementType) {
        return MonitorClass.create((double)1.0, (double)1.0, (ElementHandler[])new ElementHandler[]{new StaticObjectAdapter((Object)elementType)}).setId(CLASS_ID);
    }

    public static ElementClass createMonitorClass(Resource elementType, IElement parentElement, HashMap<String, String> substitutions, Object component, String suffix, double staticScaleX, double staticScaleY) {
        return MonitorClass.create((IElement)parentElement, substitutions, (Object)component, (String)suffix, (double)staticScaleX, (double)staticScaleY, (ElementHandler[])new ElementHandler[]{new StaticObjectAdapter((Object)elementType)}).setId(CLASS_ID);
    }

    public void create(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType, AsyncProcedure<ElementClass> procedure) {
        procedure.execute(graph, (Object)MonitorClassFactory2.createMonitorClass(elementType));
    }

    public void load(ReadGraph graph, ICanvasContext canvas, IDiagram diagram, final Resource element, IElement e) throws DatabaseException {
        Color color;
        String suffix;
        if (!graph.hasStatement(element)) {
            return;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        e.setHint(ElementHints.KEY_OBJECT, (Object)element);
        e.setHint(SynchronizationHints.HINT_SYNCHRONIZER, (Object)HINT_SYNCHRONIZER);
        AffineTransform at = DiagramGraphUtil.getAffineTransform((ReadGraph)graph, (Resource)element);
        ElementUtils.setTransform((IElement)e, (AffineTransform)at);
        Resource hAlign = graph.getPossibleObject(element, G2D.HasHorizontalAlignment);
        Resource vAlign = graph.getPossibleObject(element, G2D.HasVerticalAlignment);
        Double borderWidth = (Double)graph.getPossibleRelatedValue(element, G2D.HasStrokeWidth);
        Double direction = (Double)graph.getPossibleRelatedValue(element, DIA.HasDirection);
        double[] bounds = DiagramGraphUtil.getPossibleRelatedDoubleArray((ReadGraph)graph, (Resource)element, (Resource)G2D.HasBounds);
        if (bounds != null) {
            e.setHint(ElementHints.KEY_BOUNDS, (Object)new Rectangle2D.Double(bounds[0], bounds[1], bounds[2], bounds[3]));
        }
        if (hAlign != null) {
            e.setHint(ElementHints.KEY_HORIZONTAL_ALIGN, (Object)DiagramGraphUtil.toAlignment((Resource)hAlign, (G2DResource)G2D, (Alignment)MonitorClass.DEFAULT_HORIZONTAL_ALIGN));
        }
        if (vAlign != null) {
            e.setHint(ElementHints.KEY_VERTICAL_ALIGN, (Object)DiagramGraphUtil.toVerticalAlignment((Resource)vAlign, (G2DResource)G2D, (Alignment)MonitorClass.DEFAULT_VERTICAL_ALIGN));
        }
        if (direction != null) {
            e.setHint(MonitorClass.KEY_DIRECTION, (Object)direction);
        }
        if (borderWidth != null) {
            e.setHint(MonitorClass.KEY_BORDER_WIDTH, (Object)borderWidth);
        }
        if ((suffix = (String)graph.getPossibleRelatedValue(element, DIA.HasMonitorSuffix, (Binding)Bindings.STRING)) != null) {
            e.setHint(MonitorClass.KEY_MONITOR_SUFFIX, (Object)suffix);
        }
        String label = (String)graph.getPossibleRelatedValue(element, L0.HasLabel);
        ElementUtils.setText((IElement)e, (String)label);
        FontDescriptor fd = (FontDescriptor)graph.getPossibleRelatedAdapter(element, DIA.HasFont, FontDescriptor.class);
        if (fd != null) {
            ElementUtils.setTextFont((IElement)e, (Font)Fonts.awt((FontDescriptor)fd));
        }
        if ((color = (Color)graph.getPossibleRelatedAdapter(element, DIA.HasColor, Color.class)) != null) {
            ElementUtils.setTextColor((IElement)e, (java.awt.Color)Colors.awt((Color)color));
        }
        this.loadParentRelationships(graph, element, e);
        HashMap<String, String> substitutions = new HashMap<String, String>();
        substitutions.put("#v1", "");
        final Resource diagramRuntime = (Resource)diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RUNTIME_RESOURCE);
        if (diagramRuntime != null) {
            final Session session = graph.getSession();
            final AtomicReference<Function1> validator = new AtomicReference<Function1>();
            MonitorVariable monitorVariable = (MonitorVariable)((Object)graph.syncRequest((Read)new ResolveMonitorVariable(diagramRuntime, element)));
            boolean readOnly = true;
            if (monitorVariable != null) {
                RVI rvi;
                Function1 func = (Function1)monitorVariable.getVariable().getPossiblePropertyValue(graph, "HasInputValidator");
                validator.set(func);
                if (func != null) {
                    e.setHint(MonitorClass.KEY_INPUT_VALIDATOR, (Object)func);
                }
                if ((rvi = monitorVariable.getRVI()) != null) {
                    e.setHint(MonitorClass.KEY_RVI, (Object)rvi);
                }
                readOnly = Boolean.TRUE.equals(monitorVariable.getVariable().getPossiblePropertyValue(graph, "readOnly", (Binding)Bindings.BOOLEAN));
            }
            TextEditor ed = null;
            if (!readOnly && (ed = (TextEditor)e.getElementClass().getAtMostOneItemOfClass(TextEditor.class)) != null) {
                ed.setModifier(e, new TextEditor.Modifier(){

                    public String getValue(IElement e) {
                        return MonitorClass.editText((IElement)e);
                    }

                    public String isValid(IElement e, String text) {
                        if (validator.get() != null) {
                            return (String)((Function1)validator.get()).apply((Object)text);
                        }
                        return null;
                    }

                    public void modify(IElement e, final String text) {
                        session.asyncRequest((Read)new ResolveMonitorVariable(diagramRuntime, element), (Listener)new EvaluatingListener<MonitorVariable>((EvaluatingListener.Criterion)new EvaluatingListener.Criterion<MonitorVariable>(){

                            public EvaluatingListener.Evaluation evaluate(MonitorVariable result) {
                                return result != null ? EvaluatingListener.Evaluation.ACCEPT : EvaluatingListener.Evaluation.IGNORE;
                            }
                        }){

                            public void accepted(MonitorVariable var) {
                                session.asyncRequest((Write)new MonitorVariableWrite(var.getVariable(), text), e -> {
                                    if (e != null) {
                                        ErrorLogger.defaultLogError((Throwable)e);
                                    }
                                });
                            }

                            public void exception(Throwable t) {
                                ErrorLogger.defaultLogError((Throwable)t);
                            }
                        });
                    }
                });
            }
            IElement mappedElement = e;
            MonitorListener monitorListener = new MonitorListener(element, canvas, diagram, substitutions);
            if (mappedElement != null) {
                MonitorListener oldListener = (MonitorListener)mappedElement.getHint(KEY_VARIABLE_LISTENER);
                if (oldListener != null) {
                    oldListener.dispose();
                }
                mappedElement.setHint(KEY_VARIABLE_LISTENER, (Object)monitorListener);
            }
            if (monitorVariable != null) {
                graph.syncRequest((Read)new MonitorVariableValueRequest(diagramRuntime, element), (Listener)monitorListener);
            }
        }
    }

    private void loadParentRelationships(ReadGraph graph, Resource element, IElement e) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource monitorComponent = graph.getPossibleObject(element, DIA.HasMonitorComponent);
        Resource parentDiagramElement = null;
        if (monitorComponent != null) {
            parentDiagramElement = graph.getPossibleObject(monitorComponent, MOD.ComponentToElement);
        }
        if (parentDiagramElement != null) {
            final Resource pde = parentDiagramElement;
            e.setHint(DiagramModelHints.KEY_ELEMENT_LOADER, (Object)new ElementLoader(){

                public void load(ReadGraph g, IDiagram diagram, IElement element) throws DatabaseException {
                    MonitorClassFactory2.this.loadParentRelationship(g, diagram, element, pde);
                }
            });
        }
    }

    boolean loadParentRelationship(ReadGraph g, IDiagram diagram, IElement element, Resource parentElementResource) throws DatabaseException {
        RelationshipHandler rh = (RelationshipHandler)diagram.getDiagramClass().getAtMostOneItemOfClass(RelationshipHandler.class);
        if (rh == null) {
            return true;
        }
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        DataElementMap map = (DataElementMap)diagram.getDiagramClass().getSingleItem(DataElementMap.class);
        IElement parentElement = map.getElement(diagram, (Object)parentElementResource);
        if (parentElement != null) {
            element.setHint(ElementHints.KEY_PARENT_ELEMENT, (Object)parentElement);
            rh.claim(diagram, (Object)element, Relationship.CHILD_OF, (Object)parentElement);
            Resource tailNode = null;
            if (g.isInstanceOf(parentElementResource, DIA.Connection)) {
                tailNode = ConnectionUtil.getConnectionTailNode((ReadGraph)g, (Resource)parentElementResource);
            }
            if (tailNode != null) {
                IElement tailNodeElement = map.getElement(diagram, (Object)tailNode);
                if (parentElement != null) {
                    element.setHint(ElementHints.KEY_PARENT_ELEMENT, (Object)tailNodeElement);
                    rh.claim(diagram, (Object)element, Relationship.CHILD_OF, (Object)tailNodeElement);
                }
            }
            return true;
        }
        return false;
    }
}

