/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions.e4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.simantics.Simantics;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.NodeContextBuilder;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.actions.ActionBrowseContext;
import org.simantics.browsing.ui.model.actions.IActionCategory;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.actions.e4.Messages;

public class GlobalModeledToolbarActions {
    @Inject
    UISynchronize sync;
    private List<String> browseContexts;
    private boolean disposed;
    private Composite composite;
    private static final Comparator<Action> ACTION_COMPARATOR = (o1, o2) -> {
        String t1 = o1.getText();
        String t2 = o2.getText();
        return t1 == null ? (t2 == null ? 0 : -1) : (t2 == null ? 1 : t1.compareTo(t2));
    };

    @PostConstruct
    protected void create(Composite parent, MToolControl control) {
        this.composite = parent;
        this.browseContexts = new ArrayList<String>(control.getTags());
        Simantics.getSession().asyncRequest((Read)new GetContributions(Simantics.getProjectResource(), this.browseContexts), (Listener)new ContributionListener());
    }

    @PreDestroy
    private void dispose() {
        this.disposed = true;
        if (this.composite != null) {
            Control[] controlArray = this.composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
            this.composite = null;
        }
    }

    private static Collection<Resource> getBrowseContextResources(ReadGraph graph, Collection<String> browseContexts) throws DatabaseException {
        ArrayList<Resource> result = new ArrayList<Resource>(browseContexts.size());
        for (String name : browseContexts) {
            result.add(graph.getResource(name));
        }
        return result;
    }

    private static List<IContributionItem> getContributionItems(ReadGraph graph, Resource from, Collection<String> browseContextNames) throws DatabaseException {
        Collection<Resource> browseContexts = GlobalModeledToolbarActions.getBrowseContextResources(graph, browseContextNames);
        NodeContext nodeContext = NodeContextBuilder.buildWithInput((Object)from);
        try {
            ActionBrowseContext defaultContext = ActionBrowseContext.create((ReadGraph)graph, browseContexts);
            ActionBrowseContext browseContext = ActionBrowseContext.get((ReadGraph)graph, (NodeContext)nodeContext, (ActionBrowseContext)defaultContext);
            Map result = browseContext.getActions(graph, nodeContext, Collections.singletonList(nodeContext));
            return GlobalModeledToolbarActions.toContributionItems(result);
        }
        catch (InvalidContribution e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.modeling.ui", Messages.GlobalModeledToolbarActions_ActivatorEncounteredInvalidContributionException, (Throwable)e));
            return Collections.emptyList();
        }
    }

    private static List<IContributionItem> toContributionItems(Map<IActionCategory, List<Action>> map) {
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        IActionCategory[] categories = map.keySet().toArray(new IActionCategory[map.size()]);
        Arrays.sort(categories, IActionCategory.ACTION_CATEGORY_COMPARATOR);
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        boolean first = true;
        IActionCategory[] iActionCategoryArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            IActionCategory category = iActionCategoryArray[n2];
            List<Action> actions = map.get(category);
            Collections.sort(actions, ACTION_COMPARATOR);
            if (category != null && category.isSubmenu()) {
                MenuManager manager = new MenuManager(category.getLabel());
                for (Action action : actions) {
                    manager.add((IContributionItem)new ActionContributionItem((IAction)action));
                }
                items.add((IContributionItem)manager);
            } else {
                if (first) {
                    first = false;
                } else {
                    items.add((IContributionItem)new Separator(category == null ? "" : category.getLabel()));
                }
                for (Action action : actions) {
                    items.add((IContributionItem)new ActionContributionItem((IAction)action));
                }
            }
            ++n2;
        }
        return items;
    }

    class ContributionListener
    implements Listener<List<IContributionItem>>,
    Runnable {
        AtomicReference<List<IContributionItem>> lastResult = new AtomicReference();

        ContributionListener() {
        }

        public void execute(List<IContributionItem> result) {
            if (GlobalModeledToolbarActions.this.composite != null) {
                this.lastResult.set(result);
                GlobalModeledToolbarActions.this.sync.asyncExec((Runnable)this);
            }
        }

        @Override
        public void run() {
            List result = this.lastResult.getAndSet(null);
            if (result == null || GlobalModeledToolbarActions.this.composite == null || GlobalModeledToolbarActions.this.composite.isDisposed()) {
                return;
            }
            ToolBar tb = (ToolBar)GlobalModeledToolbarActions.this.composite.getParent();
            ToolItem[] toolItemArray = tb.getItems();
            int n = toolItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ToolItem item = toolItemArray[n2];
                item.dispose();
                ++n2;
            }
            for (ToolItem item : result) {
                item.fill(tb, -1);
            }
            Composite tbp = tb.getParent();
            tbp.layout(true, true);
        }

        public void exception(Throwable t) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.modeling.ui", Messages.GlobalModeledToolbarActions_ActivatorGlobalModeledToolbarException, t));
        }

        public boolean isDisposed() {
            return GlobalModeledToolbarActions.this.disposed;
        }
    }

    static class GetContributions
    extends BinaryRead<Resource, Collection<String>, List<IContributionItem>> {
        public GetContributions(Resource from, Collection<String> browseContextNames) {
            super((Object)from, browseContextNames);
        }

        public List<IContributionItem> perform(ReadGraph graph) throws DatabaseException {
            return GlobalModeledToolbarActions.getContributionItems(graph, (Resource)this.parameter, (Collection)this.parameter2);
        }
    }
}

