/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - index based searching and graph manipulation (#4255)
 *******************************************************************************/
package org.simantics.modeling.ui.view;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.ResourceInput;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.LayoutUtils;

public class ChangeInformationView extends ViewPart {

	public static final String VIEW_ID = "org.simantics.modeling.changeInformation";

	private ResourceInput input;

	private Session session;

	private ChangeInformationComposite composite;

	private IAction refreshAction;

	@Override
	public void createPartControl(Composite parent) {

		session = Simantics.getSession();

		// Initialize input
		String sid = getViewSite().getSecondaryId();
		Resource r = null;
		if (sid != null) {
			input = ResourceInput.unmarshall(sid);
			try {
				r = input.toResource(session);
			} catch (DatabaseException e) {
				ErrorLogger.defaultLogError(e);
			}
		}

		// Create UI
		parent.setLayout(LayoutUtils.createNoBorderGridLayout(1));
		composite = new ChangeInformationComposite(parent, SWT.NONE, session, r, getSite());
		composite.defaultInitializeUI();

		// Contribute actions
		makeActions();
		contributeActions(getViewSite().getActionBars());

	}

	private void makeActions() {
		refreshAction = new RefreshAction();
	}

	 private void contributeActions(IActionBars actionBars) {
		 IToolBarManager toolBar = actionBars.getToolBarManager();
		 toolBar.add(refreshAction);
	 }
	
	@Override
	public void setFocus() {
		if (composite != null)
			composite.setFocus();
	}

	class RefreshAction extends Action {
		public RefreshAction() {
			super("Refresh",
					BundleUtils.getImageDescriptorFromPlugin(SimanticsUI.PLUGIN_ID,
							"icons/refresh.gif"));
			setToolTipText("Refresh");
		}
		@Override
		public void run() {
			composite.refresh();
		}
	}

}
