/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.symbolEditor;

import java.util.Collections;
import java.util.Set;

import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.layer0.request.combinations.Combinators;
import org.simantics.diagram.handler.CopyPasteStrategy;
import org.simantics.diagram.handler.DefaultCopyPasteStrategy;
import org.simantics.diagram.participant.PointerInteractor2;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.layers.ILayer;
import org.simantics.g2d.layers.ILayers;
import org.simantics.g2d.layers.ILayersEditor;
import org.simantics.g2d.page.DiagramDesc;
import org.simantics.modeling.ui.diagramEditor.DiagramEditorStates;
import org.simantics.modeling.ui.diagramEditor.EditorState;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.editor.input.InputValidationCombinators;
import org.simantics.utils.page.PageCentering;

/**
 * @author Tuukka Lehtonen
 */
public class SymbolViewer extends org.simantics.modeling.ui.diagramEditor.DiagramViewer {

    ParametrizedRead<IResourceEditorInput, Boolean> INPUT_VALIDATOR =
        Combinators.compose(
                Combinators.compose(
                        InputValidationCombinators.hasURI(),
                        InputValidationCombinators.partialFunction(StructuralResource2.URIs.Defines)
                ),
                InputValidationCombinators.extractInputResource()
        );

    protected String getPopupId() {
        return "#SymbolViewerPopup";
    }
    
    public ParametrizedRead<IResourceEditorInput, Boolean> getInputValidator() {
        return INPUT_VALIDATOR;
    }

    @Override
    protected PointerInteractor getPointerInteractor() {
        return new PointerInteractor2(true, true, true, false, false, false, synchronizer.getElementClassProvider());
    }
    
    @Override
    protected void addDropParticipants(ICanvasContext ctx) {
        ctx.add(new PopulateTerminalDropParticipant(getResourceInput().getResource(), synchronizer));
    }

    protected void addStructureParticipants(ICanvasContext ctx) {
        addWorkbenchSelectionProvider(ctx);
    }

    @Override
    protected void setDiagramDesc(ICanvasContext ctx, DiagramDesc diagramDesc) {
        super.setDiagramDesc(ctx, diagramDesc.withPageDesc(
                diagramDesc.getPageDesc().withCentering(PageCentering.CenteredAroundOrigin)));
    }

    @Override
    protected void beforeSetDiagram(IDiagram diagram) {
        setupLayers(diagram);
    }

    protected void setupLayers(IDiagram diagram) {
        diagram.setHint(DiagramHints.KEY_LAYERS, new ILayers() {

            @Override
            public boolean isActive(ILayer layer) {
                return true;
            }

            @Override
            public Set<ILayer> getVisibleLayers() {
                return Collections.emptySet();
            }

            @Override
            public Set<ILayer> getLayers() {
                return Collections.emptySet();
            }

            @Override
            public boolean getIgnoreVisibilitySettings() {
                return true;
            }

            @Override
            public boolean getIgnoreFocusSettings() {
                return true;
            }

        });

        // Disable roles (layers) by default in symbol editor to show everything.
        ILayersEditor le = diagram.getHint(DiagramHints.KEY_LAYERS_EDITOR);
        if (le != null) {
            le.setIgnoreFocusSettings(true);
            le.setIgnoreVisibilitySettings(true);
        }
    }

    @Override
    protected EditorState getSavedEditorState(ICanvasContext ctx) {
        return DiagramEditorStates.toEditorState(ctx, true, true, false);
    }

    protected CopyPasteStrategy getDefaultCopyPasteStrategy() {
        return new SymbolEditorCopyPasteStrategy();
    }

}
