/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.symbolEditor;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.participant.GridPainter;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.datastructures.hints.IHintContext.Key;

/**
 * A function and a listener for diagram grid visibility. The function
 * returns the current grid visibility as a Boolean.
 * 
 * @author Tuukka Lehtonen
 */
public class GridVisibleFunction extends HintListenerAdapter implements Function1<Object, Boolean> {

	Boolean enabled;

	public GridVisibleFunction(ICanvasContext ctx) {
		IHintContext hctx = ctx.getDefaultHintContext();
		// Initialize state
		hintChanged(hctx, GridPainter.KEY_GRID_ENABLED, null, hctx.getHint(GridPainter.KEY_GRID_ENABLED));
		// Start listening
		hctx.addKeyHintListener(GridPainter.KEY_GRID_ENABLED, this);
	}

	@Override
	public void hintChanged(IHintObservable sender, Key key, Object oldValue, Object newValue) {
		enabled = Boolean.valueOf(Boolean.TRUE.equals(newValue));
	}

	@Override
	public Boolean apply(Object p0) {
		return enabled;
	}

}