/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.preferences;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.modeling.preferences.SubscriptionPreferences;
import org.simantics.ui.workbench.preferences.NumberFieldEditor;

public class SubscriptionPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {

    private NumberFieldEditor fSubscriptionDeadbandEditor = null;
    private NumberFieldEditor fSubscriptionIntervalEditor = null;
    private NumberFieldEditor fSubscriptionGainEditor = null;
    private NumberFieldEditor fSubscriptionBiasEditor = null;
    		
    /**
     * Create the console page.
     */
    public SubscriptionPreferencePage() {
        super(GRID);

        //setDescription("Subscription preferences");
        IPreferenceStore pf = new ScopedPreferenceStore(InstanceScope.INSTANCE, SubscriptionPreferences.P_NODE);
        setPreferenceStore( pf );
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#createControl(Composite)
     */
    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    /**
     * Create all field editors for this page
     */
    @Override
    public void createFieldEditors() {
        Group newItemGroup = new Group(getFieldEditorParent(), SWT.NONE);
        newItemGroup.setText("Default settings for new subscription items");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo(newItemGroup);
        FillLayout fl = new FillLayout();
        fl.marginWidth = 5;
        fl.marginHeight = 5;
        newItemGroup.setLayout(fl);
        Composite newItemSettings = new Composite(newItemGroup, SWT.NONE);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(newItemSettings);

        fSubscriptionIntervalEditor = new NumberFieldEditor(SubscriptionPreferences.P_SUBSCRIPTION_INTERVAL, "Sampling Interval (s)", newItemSettings);
        fSubscriptionIntervalEditor.setValidRange(0, Double.MAX_VALUE);
        fSubscriptionIntervalEditor.setErrorMessage("Default sampling interval value is invalid");
        addField(fSubscriptionIntervalEditor);

        fSubscriptionDeadbandEditor = new NumberFieldEditor(SubscriptionPreferences.P_SUBSCRIPTION_DEADBAND, "Deadband", newItemSettings);
        fSubscriptionDeadbandEditor.setValidRange(0., Double.MAX_VALUE);
        fSubscriptionDeadbandEditor.setErrorMessage("Default deadband value is invalid");
        addField(fSubscriptionDeadbandEditor);

        fSubscriptionGainEditor = new NumberFieldEditor(SubscriptionPreferences.P_SUBSCRIPTION_GAIN, "Gain", newItemSettings);
        addField(fSubscriptionGainEditor);

        fSubscriptionBiasEditor = new NumberFieldEditor(SubscriptionPreferences.P_SUBSCRIPTION_BIAS, "Bias", newItemSettings);
        addField(fSubscriptionBiasEditor);
    }

    /**
     * @see IWorkbenchPreferencePage#init(IWorkbench)
     */
    @Override
    public void init(IWorkbench workbench) {
    }


}
