/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.Preferences;
import org.simantics.modeling.ui.Activator;
import org.simantics.utils.page.PageDesc;

public class PreferenceInitializer extends AbstractPreferenceInitializer {

    /* (non-Javadoc)
     * @see org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer#initializeDefaultPreferences()
     */
    @Override
    public void initializeDefaultPreferences() {
        IScopeContext context = DefaultScope.INSTANCE;
        Preferences node = context.getNode(Activator.PLUGIN_ID);

        node.putDouble(DiagramPreferences.P_SNAP_GRID_SIZE, DiagramPreferences.DEFAULT_SNAP_GRID_SIZE);
        node.put(DiagramPreferences.P_DEFAULT_PAGE_SIZE, PageDesc.serialize(DiagramPreferences.DEFAULT_PAGE_SIZE));
//        node.put(DiagramPreferences.P_DEFAULT_PAGE_ORIENTATION, DiagramPreferences.DEFAULT_PAGE_ORIENTATION.toString());
//        node.put(DiagramPreferences.P_DEFAULT_PAGE_MARGINS, PageDesc.serialize(DiagramPreferences.DEFAULT_PAGE_MARGINS));
        node.putBoolean(DiagramPreferences.P_DISPLAY_PAGE_SIZE, DiagramPreferences.DEFAULT_DISPLAY_PAGE_SIZE);
        node.putBoolean(DiagramPreferences.P_DISPLAY_MARGINS, DiagramPreferences.DEFAULT_DISPLAY_MARGINS);
        node.putBoolean(DiagramPreferences.P_DISPLAY_GRID, DiagramPreferences.DEFAULT_DISPLAY_GRID);
        node.putBoolean(DiagramPreferences.P_DISPLAY_RULER, DiagramPreferences.DEFAULT_DISPLAY_RULER);

        node.put(ModelingPreferences.P_PROPERTY_PIN_MODE, ModelingPreferences.DEFAULT_PIN_MODE.name());
    }

}
