/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.preferences;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.simantics.modeling.ui.Activator;
import org.simantics.utils.page.PageDesc;

/**
 * @author Tuukka Lehtonen
 */
public final class DiagramPreferenceUtil {

    public static final String PLUGIN_ID = Activator.PLUGIN_ID;

    public static DiagramPreferences getDefaultPreferences() {
        return getPreferences(DefaultScope.INSTANCE);
    }

    /**
     * @return
     */
    public static DiagramPreferences getPreferences() {
        return getPreferences(InstanceScope.INSTANCE);
    }

    /**
     * @return
     */
    public static DiagramPreferences getPreferences(IScopeContext context) {
        IEclipsePreferences node = context.getNode(PLUGIN_ID);
        double gridSize = node.getDouble(DiagramPreferences.P_SNAP_GRID_SIZE, DiagramPreferences.DEFAULT_SNAP_GRID_SIZE);
        PageDesc pageDesc = getPageDesc(node);
        //System.out.println("GET pagedesc: " + pageDesc);
        //String pos = node.get(DiagramPreferences.P_DEFAULT_PAGE_ORIENTATION, DiagramPreferences.DEFAULT_PAGE_ORIENTATION.toString());
        //PageOrientation po = PageOrientation.valueOf(pos);

//        Margins margins = DiagramPreferences.DEFAULT_PAGE_MARGINS;
//        String marginString = node.get(DiagramPreferences.P_DEFAULT_PAGE_MARGINS, null);
//        if (marginString != null)
//            margins = PageDesc.deserializeMargins(marginString, margins);
//        pageDesc = pageDesc.withMargins(margins);

        boolean displayPage = node.getBoolean(DiagramPreferences.P_DISPLAY_PAGE_SIZE, DiagramPreferences.DEFAULT_DISPLAY_PAGE_SIZE);
        boolean displayMargins = node.getBoolean(DiagramPreferences.P_DISPLAY_MARGINS, DiagramPreferences.DEFAULT_DISPLAY_MARGINS);
        boolean displayGrid = node.getBoolean(DiagramPreferences.P_DISPLAY_MARGINS, DiagramPreferences.DEFAULT_DISPLAY_GRID);
        boolean displayRuler = node.getBoolean(DiagramPreferences.P_DISPLAY_MARGINS, DiagramPreferences.DEFAULT_DISPLAY_RULER);

        Map<String, Object> map = new HashMap<String, Object>();
        map.put(DiagramPreferences.P_SNAP_GRID_SIZE, gridSize);
        map.put(DiagramPreferences.P_DEFAULT_PAGE_SIZE, pageDesc);
//        map.put(DiagramPreferences.P_DEFAULT_PAGE_ORIENTATION, po);
//        map.put(DiagramPreferences.P_DEFAULT_PAGE_MARGINS, margins);
        map.put(DiagramPreferences.P_DISPLAY_PAGE_SIZE, displayPage);
        map.put(DiagramPreferences.P_DISPLAY_MARGINS, displayMargins);
        map.put(DiagramPreferences.P_DISPLAY_GRID, displayGrid);
        map.put(DiagramPreferences.P_DISPLAY_RULER, displayRuler);

        return new DiagramPreferences(node, map);
    }

    /**
     * @return
     * @throws BackingStoreException
     */
    public static void setPreferences(DiagramPreferences prefs) {
        _setPreferences(InstanceScope.INSTANCE, prefs);
    }

    /**
     * @return
     * @throws BackingStoreException
     */
    public static void flushPreferences(DiagramPreferences prefs) throws BackingStoreException {
        Preferences p = _setPreferences(InstanceScope.INSTANCE, prefs);
        p.flush();
    }

    /**
     * @return
     * @throws BackingStoreException
     */
    public static void setPreferences(IScopeContext context, DiagramPreferences prefs) {
        _setPreferences(context, prefs);
    }

    /**
     * @return
     * @throws BackingStoreException
     */
    private static IEclipsePreferences _setPreferences(IScopeContext context, DiagramPreferences prefs) {
        IEclipsePreferences node = context.getNode(PLUGIN_ID);
        //System.out.println("SET pagedesc: " + prefs.get(DiagramPreferences.P_DEFAULT_PAGE_SIZE));
        node.putDouble(DiagramPreferences.P_SNAP_GRID_SIZE, (Double) prefs.get(DiagramPreferences.P_SNAP_GRID_SIZE));
        node.put(DiagramPreferences.P_DEFAULT_PAGE_SIZE, PageDesc.serialize((PageDesc) prefs.get(DiagramPreferences.P_DEFAULT_PAGE_SIZE)));
//        node.put(DiagramPreferences.P_DEFAULT_PAGE_ORIENTATION, prefs.get(DiagramPreferences.P_DEFAULT_PAGE_ORIENTATION).toString());
//        node.put(DiagramPreferences.P_DEFAULT_PAGE_MARGINS, PageDesc.serialize((Margins) prefs.get(DiagramPreferences.P_DEFAULT_PAGE_MARGINS)));
        node.putBoolean(DiagramPreferences.P_DISPLAY_PAGE_SIZE, (Boolean) prefs.get(DiagramPreferences.P_DISPLAY_PAGE_SIZE));
        node.putBoolean(DiagramPreferences.P_DISPLAY_MARGINS, (Boolean) prefs.get(DiagramPreferences.P_DISPLAY_MARGINS));
        node.putBoolean(DiagramPreferences.P_DISPLAY_GRID, (Boolean) prefs.get(DiagramPreferences.P_DISPLAY_GRID));
        node.putBoolean(DiagramPreferences.P_DISPLAY_RULER, (Boolean) prefs.get(DiagramPreferences.P_DISPLAY_RULER));
        return node;
    }

    private static PageDesc getPageDesc(IEclipsePreferences node) {
        String desc = node.get(DiagramPreferences.P_DEFAULT_PAGE_SIZE, null);
        return PageDesc.deserialize(desc, DiagramPreferences.DEFAULT_PAGE_SIZE);
    }

}
