/*******************************************************************************
 * Copyright (c) 2007, 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - (#7084) page numbering
 *******************************************************************************/
package org.simantics.modeling.ui.pdf;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.simantics.db.common.NamedResource;
import org.simantics.db.management.ISessionContext;
import org.simantics.export.core.pdf.PageNumbering;
import org.simantics.modeling.requests.CollectionResult;
import org.simantics.modeling.requests.Node;
import org.simantics.project.IProject;

public class PDFExportPlan {

    // Input
    public ISessionContext           sessionContext;
    public IProject                  project;
    public IStructuredSelection      initialSelection;
    public NamedResource             initialModelSelection;
    public List<NamedResource>       selectableModels = new ArrayList<NamedResource>();
    public NamedResource             selection;
    public Collection<String>        recentLocations;

    // Temporary data
    public CollectionResult          nodes           = new CollectionResult();
    public Set<Node>                 selectedNodeSet = new HashSet<Node>();

    // Output
    //NamedResource             model;
    public File                      exportLocation;
    public Collection<Node>          selectedNodes;

    // I/O

    /**
     * <code>false</code> to print content as is regardless of whether it goes
     * outside printed page boundaries. <code>true</code> to scale the content
     * so that it fills the printed page size and the specified margins. If the
     * content goes over page boundaries, it is shrunk and if it doesn't fill
     * the page boundaries, it is scaled up uniformly to fill them either
     * horizontally or vertically.
     */
    public boolean                   fitContentToPageMargins    = false;

    /**
     * <code>true</code> to attach TG of the diagram and the model.
     */
    public boolean attachTG = false;

    /**
     * <code>true</code> to attach Wiki page.
     */
    public boolean attachWiki = false;

    /**
     * Whether or not to add page numbers to the exported PDF. Default value is
     * {@value #addPageNumbers}.
     * 
     * @since 1.28.0
     */
    public boolean addPageNumbers = true;

    /**
     * This is ignored if {@link #addPageNumbers} is <code>false</code>.
     */
    public PageNumbering.Position pageNumberPosition = PageNumbering.Position.BOTTOM_RIGHT;

    /**
     * This is ignored if {@link #addPageNumbers} is <code>false</code>.
     */
    public PageNumbering.NumberingFormat pageNumberFormat = PageNumbering.NumberingFormat.PAGE_SLASH_TOTAL_PAGES;


    public PDFExportPlan(ISessionContext sessionContext, Collection<String> recentLocations) {
        this.sessionContext = sessionContext;
        this.recentLocations = recentLocations;
    }

}
