/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.model;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.common.node.IModifiable;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;
import org.simantics.structural.stubs.StructuralResource2;

@Deprecated
public class ComponentType extends Node implements IModifiable {

    final static boolean showFolders = true;

    Resource content;
    Resource instance;

    public ComponentType(ReadGraph g, Resource resource) throws DatabaseException {
        this(g, resource, null);
    }

    public ComponentType(ReadGraph g, Resource resource, Resource instance) throws DatabaseException {
        super(resource);
        StructuralResource2 sr = StructuralResource2.getInstance(g);
        this.content = g.getPossibleObject(resource, sr.IsDefinedBy);
        this.instance = instance;
    }

    @Override
    public Collection<?> getChildren(ReadGraph g) throws DatabaseException {
        Collection<INode> ret = new ArrayList<INode>(3);
        ret.add(new Interface(resource, instance, false));
        if(content != null) {
            ret.add(new Decorator(g.adapt(content, INode.class)) {
                @Override
                public String getLabel(ReadGraph g) {
                    return "Content";
                }
            });
        }
        for(Resource symbol : g.getObjects(resource, ModelingResources.getInstance(g).ComponentTypeToSymbol))
            ret.add(new Symbol(symbol));
        if(!showFolders) {
            ArrayList<Object> flatten = new ArrayList<Object>();
            for(INode n : ret)
                flatten.addAll(n.getChildren(g));
            return flatten;
        }
        return ret;
    }

    @Override
    public ImageDescriptor getImage(ReadGraph g) {
        return Activator.COMPONENT_TYPE_ICON;
    }

    @Override
    public String getLabel(ReadGraph g) throws DatabaseException {
    	Layer0 b = Layer0.getInstance(g);
    	return g.getPossibleRelatedValue(resource, b.HasName);
    }

    @Override
    public boolean equals(Object obj) {
        if(this == obj)
            return true;
        if(obj == null)
            return false;
        if(!getClass().equals(obj.getClass()))
            return false;
        ComponentType other = (ComponentType)obj;
        return resource.equals(other.resource)
        && content.equals(other.content)
        && (instance == null ? other.instance == null : instance.equals(other.instance));
    }

    @Override
    public int hashCode() {
        return ((getClass().hashCode()*31 + (instance == null ? 0 : instance.hashCode()))*31
                +  content.hashCode())*31 + resource.hashCode();
    }

    @Override
    public Modifier getModifier(final Session session, String columnId) {
        return new Modifier() {

            @Override
            public String getValue() {
                Read<String> request =
                    new Read<String>() {

                    @Override
                    public String perform(ReadGraph graph) throws DatabaseException {
                    	Layer0 b = Layer0.getInstance(graph);
                        String name = graph.getPossibleRelatedValue(resource, b.HasName);
                        return name != null ? name : "";
                    }

                };
                try {
                    return session.syncRequest(request);
                } catch (DatabaseException e) {
                    e.printStackTrace();
                    return "";
                }
            }

            @Override
            public String isValid(String label) {
                return null;
            }

            @Override
            public void modify(final String label) {
                session.asyncRequest(new WriteRequest() {
                    @Override
                    public void perform(WriteGraph graph) throws DatabaseException {
                    	Layer0 b = Layer0.getInstance(graph);
                        graph.claimLiteral(resource, b.HasName, label);
                    }
                });
            }

        };
    }
}
