/*******************************************************************************
 * Copyright (c) 2007 VTT Technical Research Centre of Finland and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.handlers;


import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.Adapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.PasteHandler;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardPasteHandler extends AbstractHandler implements IHandler {

    private static final Logger LOGGER = LoggerFactory.getLogger(StandardPasteHandler.class);

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {

        final ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        final PasteHandler handler = SimanticsUI.filterSingleSelection(selection, PasteHandler.class);
    	if (handler != null) {
        	
    		try {
    			
    		    Simantics.getSession().markUndoPoint();
    			IRunnableWithProgress op = pasteResourceFromClipboard(handler);
    			
    			Shell shell = HandlerUtil.getActiveShell(event);
    			new ProgressMonitorDialog(shell).run(true, true, op);
    			
    		} catch (InvocationTargetException e) {
    			Throwable t = e.getCause();
    			if (t != null) {
        			ExceptionUtils.logAndShowError("Paste Failed", t.getMessage(), e);
    			} else {
    				ExceptionUtils.logAndShowError("Paste Failed", "Paste failed for unknown reason.", e);
    			}
    		} catch (InterruptedException e) {
    			ErrorLogger.defaultLogError(e);
    		}
        	
        }
    	return null;
    }
    
    public static IRunnableWithProgress pasteResourceFromClipboard(final PasteHandler handler) {
    	
    	IRunnableWithProgress op = new IRunnableWithProgress() {

			@Override
			public void run(IProgressMonitor monitor) throws InvocationTargetException,
			InterruptedException {
				SubMonitor progress = SubMonitor.convert(monitor, 100);
				try {
					progress.beginTask("Copying", 100);
					progress.worked(50);
					progress.subTask("Please wait..");
		            handler.pasteFromClipboard(Simantics.getClipboard());
				} catch (Exception e) {
					throw new InvocationTargetException(e);
				} finally {
					monitor.done();
				}
			}
		};
		return op;
    	
    }

    public static void pasteResourceFromClipboardWithoutMonitor (final PasteHandler handler) {
        try {
            handler.pasteFromClipboard(Simantics.getClipboard());
        } catch (DatabaseException e) {
            LOGGER.error("Failed to paste resource from clipboard with handler {}", handler, e); //$NON-NLS-1$
        }
    }

    public static <T> T getPasteHandlerFromResource (Resource resource, Class<T> assignableFrom) {
        try {
            return Simantics.getSession().syncRequest(new Adapter<T>(resource, assignableFrom));
        } catch (DatabaseException e) {
            LOGGER.error("Failed to get paste handler from resource {}", resource, e); //$NON-NLS-1$
            return null;
        }
    }

}