/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.handlers;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.modeling.flags.LiftFlag;
import org.simantics.utils.ui.ISelectionUtils;

/**
 * See <a href="https://www.simantics.org/wiki/index.php/Modeling_ontology#Creating_connection_points}">Creating connection points</a>
 * 
 * @author Hannu Niemistö
 */
public class CreateConnectionPoint extends AbstractHandler {

    private static List<Resource> getFlagResource(ISelection sel) {
        return ISelectionUtils.getPossibleKeys(sel, SelectionHints.KEY_MAIN, Resource.class);
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection(event);
        List<Resource> flags = getFlagResource(sel);
        if (flags.isEmpty())
            return null;
        final Set<Resource> flagSet = new HashSet<Resource>(flags);

        Simantics.getSession().asyncRequest(new WriteRequest() {
            @Override
            public void perform(WriteGraph g) throws DatabaseException {
                for (Resource flag : flagSet)
                    LiftFlag.liftFlag(g, flag);
            }
        });

        return null;
    }
    
}

