package org.simantics.modeling.ui.expression;

import org.simantics.basicexpression.Expressions;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.EquationExpression;
import org.simantics.db.layer0.variable.Expression;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.utils.datastructures.Triple;

public class BasicExpression implements Expression, EquationExpression {

	final private Resource expression;
	
	public BasicExpression(Resource expression) {
		this.expression = expression;
	}
	
	@Override
	public <T> T evaluate(ReadGraph graph, Variable property, Binding binding) throws DatabaseException {
		return evaluate(graph, property);
	}

	@SuppressWarnings("unchecked")
    @Override
	public <T> T evaluate(ReadGraph graph, Variable property) throws DatabaseException {
	
		String expressionString = graph.getValue(expression, Bindings.STRING);
		BasicExpressionVisitor visitor = new BasicExpressionVisitor(graph, property);
		Expressions.evaluate(expressionString, visitor);
		return (T)visitor.getResult();
		
	}

	@Override
	public <T> void invert(WriteGraph graph, Variable property, T value, Binding binding) throws DatabaseException {
		
		String expressionString = graph.getValue(expression, Bindings.STRING);
		InvertBasicExpressionVisitor visitor = new InvertBasicExpressionVisitor();
		Expressions.evaluate(expressionString, visitor);
		Object pair = visitor.getResult();
		if(pair instanceof Triple) {
			@SuppressWarnings("unchecked")
			Triple<Double, Double, String> data = (Triple<Double, Double, String>)pair;
			if(Math.abs(data.first) > 1e-9) {
				Double inverted = ((Double)value - data.second) / data.first;
				String target = data.third;
				Variable targetVariable = property.browse(graph, target);
//				System.out.println("invert: " + target + " = " + property.browse(graph, target).getURI(graph));
				targetVariable.setValue(graph, inverted, binding);
			}
		}
		
	}

	@Override
	public boolean isInvertible(ReadGraph graph, Variable property) throws DatabaseException {
		
		String expressionString = graph.getValue(expression, Bindings.STRING);
		InvertBasicExpressionVisitor visitor = new InvertBasicExpressionVisitor();
		Expressions.evaluate(expressionString, visitor);
		Object value = visitor.getResult();
		if(value instanceof Triple) return true;
		else return false;
		
	}

}
