/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagramEditor;

import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ui.Activator;
import org.simantics.ui.workbench.ResourceEditorInput2;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

/**
 * @author Tuukka Lehtonen
 */
public class OpenDiagramAdapter extends AbstractResourceEditorAdapter {

    private static final String EDITOR_ID = "org.simantics.modeling.ui.plainDiagramEditor"; //$NON-NLS-1$

    public OpenDiagramAdapter() {
        super(Messages.OpenDiagramAdapter_DiagramEditor, Activator.COMPOSITE_ICON);
    }

    protected String getEditorId() {
        return EDITOR_ID;
    }

    @Override
    public boolean canHandle(ReadGraph g, Resource r) throws DatabaseException {
        return g.isInstanceOf(r, DiagramResource.getInstance(g).Diagram);
    }

    @Override
    public void openEditor(final Resource r) throws Exception {
    	
        Simantics.getSession().asyncRequest(new ReadRequest() {
        	
            @Override
            public void run(ReadGraph g) throws DatabaseException {

            	final Resource model = g.sync(new PossibleModel(r));
            	if(model == null) return;

                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable() {
                    @Override
                    public void run() {
                    	try {
                    		String editorId = getEditorId();
                    		WorkbenchUtils.openEditor(editorId, new ResourceEditorInput2(editorId, r, model, (RVI)null));
                    	} catch (PartInitException e) {
                    		ErrorLogger.defaultLogError(e);
                    	}
                    }
                });
            }
        });
    }

}
