package org.simantics.modeling.ui.diagram.monitor;

import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;

public class CurrentTemplateFactory extends ReadFactoryImpl<Resource, String> {

	@Override
	public String perform(ReadGraph graph, Resource monitor) throws DatabaseException {
		
		Layer0 L0 = Layer0.getInstance(graph);
		Layer0X L0X = Layer0X.getInstance(graph);
		Resource template = graph.getPossibleObject(monitor, L0X.ObtainsProperty);
		if (template != null) {
			return graph.getPossibleRelatedAdapter(template, L0.HasLabel, String.class);
		} else {
			return null;
		}
		
	}
	
}
