/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.chart.property;

import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListenerImpl;
import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;

/**
 * @author Toni Kalajainen
 */
public class TimePropertyModifier extends TextModifyListenerImpl<Resource> {

    final private String propertyURI;
    TimeInputValidator validator;

    public TimePropertyModifier(ISessionContext context, String propertyURI, TimeInputValidator validator) {
        this.propertyURI = propertyURI;
        this.validator = validator;
    }

    @Override
    public void applyText(WriteGraph graph, Resource input, String text) throws DatabaseException {
        Double x = validator.parse(text);
        if (x == null) {
            if (graph.hasStatement(input, graph.getResource(propertyURI)))
                graph.denyValue(input, graph.getResource(propertyURI));
        } else {
            graph.claimLiteral(input, graph.getResource(propertyURI), x, Bindings.DOUBLE);
        }
    }

}

