/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.chart.property;

import java.text.Format;

import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.datastructures.Triple;
import org.simantics.utils.format.TimeFormat;

/**
 * @author Toni Kalajainen
 */
public class TimePropertyFactory extends ReadFactoryImpl<Resource, String> {

    final private String propertyURI;

    public TimePropertyFactory(String propertyURI) {
        this.propertyURI = propertyURI;
    }

    @Override
    public Object getIdentity(Object inputContents) {
        return new Triple<Resource, String, Object>((Resource) inputContents, propertyURI, getClass());
    }

    @Override
    public String perform(ReadGraph graph, Resource r) throws DatabaseException {
        Double value = graph.getPossibleRelatedAdapter(r, graph.getResource(propertyURI), Double.class);
        if (value == null) return ""; //$NON-NLS-1$
    	Format timeFormat = new TimeFormat(100, 3);
        return timeFormat.format(value);
    }

}
