/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ModelingUtils;
import org.simantics.modeling.ui.Activator;
import org.simantics.operation.Layer0X;
import org.simantics.structural.stubs.StructuralResource2;

public class NewProceduralComponentType implements ActionFactory {

    public static Resource create(WriteGraph graph, Resource library) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance(graph);
        Layer0 L0 = Layer0.getInstance(graph);
        Layer0X L0X = Layer0X.getInstance(graph);
        StructuralResource2 STR = StructuralResource2.getInstance(graph);
        DiagramResource DIA = DiagramResource.getInstance(graph);

        // New component type
        CommonDBUtils.selectClusterSet(graph, library);
        Resource componentType = graph.newResource();
        graph.newClusterSet(componentType);
        CommonDBUtils.selectClusterSet(graph, componentType);
        
        graph.claim(componentType, L0.PartOf, library);
        
        Resource indexRoot = graph.sync(new PossibleIndexRoot(library));

        // Supertype
        Resource supertype = graph.getSingleObject(indexRoot, MOD.StructuralModel_HasComponentTypeSupertype);
        graph.claim(componentType, L0.Inherits, null, supertype);
        
        graph.claim(componentType, L0.InstanceOf, STR.ProceduralComponentType);

        // Name
        String defaultName = graph.getRelatedValue(indexRoot, MOD.StructuralModel_HasDefaultComponentTypeName, Bindings.STRING);
        String name = NameUtils.findFreshName(graph, defaultName, library);
        graph.claimLiteral(componentType, L0.HasName, name + "@1"); //$NON-NLS-1$
        graph.claimLiteral(componentType, L0X.HasGeneratedNamePrefix, ""); //$NON-NLS-1$

        // Substructure
//        Resource substructureType = graph.getSingleObject(indexRoot, MOD.StructuralModel_HasComponentTypeSubstructureType);
//        Resource composite = new InstantiateRequest(substructureType).perform(graph);
//        graph.claim(componentType, STR.IsDefinedBy, composite);
        // These are added to give the configuration a proper URI.
//        graph.claimLiteral(composite, L0.HasName, "Configuration");
//        graph.claim(componentType, L0.ConsistsOf, composite);

        // Attach trigger to keep component type interface structures up-to-date
//        Resource diagram = graph.getPossibleObject(composite, MOD.CompositeToDiagram);
//        if (diagram != null) {
//            Resource componentTypeUpdater = graph.newResource();
//            graph.claim(componentTypeUpdater, L0.InstanceOf, null, MOD.ComponentTypeUpdater);
//            graph.claim(diagram, L0X.HasTrigger, componentTypeUpdater);
//        }

        graph.addLiteral(componentType, STR.ProceduralComponentType_code, STR.ProceduralComponentType_code_Inverse, 
                STR.ProceduralComponentTypeCode, "[]", Bindings.STRING); //$NON-NLS-1$
        
        Resource symbolDiagramType = graph.getPossibleObject(indexRoot, MOD.StructuralModel_HasSymbolDiagramType);
        if(symbolDiagramType == null) symbolDiagramType = DIA.Composite;
        
        // Symbol
        Resource symbol = new ModelingUtils(graph).createSymbol2("Symbol", symbolDiagramType); //$NON-NLS-1$
        graph.claim(componentType, MOD.ComponentTypeToSymbol, symbol);
        graph.claim(componentType, L0.ConsistsOf, symbol);
        
//        CommentMetadata cm = graph.getMetadata(CommentMetadata.class);
//        graph.addMetadata(cm.add("Created new user component " + name + ", resource " + componentType));
        
        return componentType;
    }

    @Override
    public Runnable create(Object target) {
        if(!(target instanceof Resource))
            return null;
        final Resource library = (Resource) target;
        return new Runnable() {
            @Override
            public void run() {
                Job job = new DatabaseJob(Messages.NewProceduralComponentType_NewUserComponent) {
                    @Override
                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            Simantics.getSession().syncRequest(new WriteRequest() {
                                @Override
                                public void perform(WriteGraph graph) throws DatabaseException {
                                    graph.markUndoPoint();
                                    Resource r = NewProceduralComponentType.create(graph, library);
                                    Layer0Utils.addCommentMetadata(graph, "Created new Procedural Component Type " + graph.getPossibleRelatedValue2(r, Layer0.getInstance(graph).HasName, Bindings.STRING)); //$NON-NLS-1$
                                }
                            });
                            return Status.OK_STATUS;
                        } catch (DatabaseException e) {
                            return new Status(IStatus.ERROR, Activator.PLUGIN_ID, Messages.NewProceduralComponentType_ActivatorFailedToCreateNewUserComponent, e); 
                        }
                    }
                };
                job.schedule();
            }
        };
    }

}
