package org.simantics.modeling.ui.actions;

import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.request.PossibleURI;
import org.simantics.modeling.ui.wizard.MigrateWizard;

/**
 * @author Antti Villberg
 */
public class MigrateComponentType implements ActionFactory {

    @Override
    public Runnable create(Object target) {
    	
        if (!(target instanceof Resource))
            return null;
        
        final Resource r = (Resource)target;

        return new Runnable() {

			@Override
			public void run() {
				
				try {
					
					final String initial = Simantics.sync(new PossibleURI(r));
	
					Display.getDefault().asyncExec(new Runnable() {

						@Override
						public void run() {
							
			                final int SIZING_WIZARD_WIDTH  = 500;
			                final int SIZING_WIZARD_HEIGHT = 600;
			                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
			                MigrateWizard wizard = new MigrateWizard(initial);
			                WizardDialog dialog = new WizardDialog(window.getShell(), wizard);
			                dialog.create();
			                dialog.getShell().setSize(Math.max(SIZING_WIZARD_WIDTH, dialog.getShell().getSize().x), SIZING_WIZARD_HEIGHT);
			                dialog.open();
							
						}
						
					});
					
				} catch (DatabaseException e) {
					Logger.defaultLogError(e);
				}
				
			}
        	
        };
        
    }

}
