package org.simantics.modeling.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.simantics.db.Resource;
import org.simantics.modeling.ui.modelBrowser.handlers.StandardCopyHandler;
import org.simantics.modeling.ui.modelBrowser.handlers.StandardPasteHandler;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.PasteHandler;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.utils.CanvasUtils;

public class SCLClipboard {
	
	public static void copyNode (Resource node) {
		
		ISelection selection = ISelectionUtils.createSelection(node);
		Resource[] rs = new Resource[] {node};
		StandardCopyHandler.copyResourcesToClipboard(rs, selection, new NullProgressMonitor());
	}
	
	public static void pasteNode (Resource target) {
		
		PasteHandler handler = StandardPasteHandler.getPasteHandlerFromResource(target, PasteHandler.class);
		StandardPasteHandler.pasteResourceFromClipboardWithoutMonitor(handler);
	}
	
	public static void copyPasteNode(Resource node, Resource target) {
		
		copyNode(node);
		pasteNode(target);
	}
	
    public static boolean copyPasteDiagramContents (final ICanvasContext source_ctx, final ICanvasContext target_ctx, List<Resource> modules) throws DatabaseException {
    	
    	IDiagram idiagram = source_ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);

		DataElementMap dem = idiagram.getDiagramClass().getAtMostOneItemOfClass(DataElementMap.class);
		if (dem != null) {
			final Collection<IElement> newSelection = new ArrayList<IElement>();
			for (Resource module : modules) {
				IElement element = dem.getElement(idiagram, module);
				if (element != null) {
					newSelection.add(element);
				} else {
					throw new DatabaseException("Could not find IElement for " + element); //$NON-NLS-1$
				}
			}
			
			ThreadUtils.syncExec(source_ctx.getThreadAccess(), new Runnable() {
	            @Override
	            public void run() {
	                if (source_ctx.isDisposed())
	                    return;
	                Selection selection = source_ctx.getAtMostOneItemOfClass(Selection.class);
	                if (selection != null) {
	                    // This prevents workbench selection from being left over.
	                    // Also prevents scene graph crap from being left on the screen.
	                    selection.setSelection(0, newSelection);
	                }
	        		CanvasUtils.sendCommand(source_ctx, Commands.COPY);
	        		CanvasUtils.sendCommand(target_ctx, Commands.PASTE);
	            }
	        });
			
		//}
		
		while(source_ctx.getEventQueue().size() > 0) {
			try {
				Thread.sleep(10);
			} catch (InterruptedException e) {
				throw new DatabaseException(e);
			}
		}

		ThreadUtils.syncExec(source_ctx.getThreadAccess(), new Runnable() {
            @Override
            public void run() {
            }
        });		
	        		
		}
		return true;
    }
    
    public static boolean delete (final ICanvasContext source_ctx, List<Resource> modules) throws DatabaseException {
    	
    	IDiagram idiagram = source_ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);

		DataElementMap dem = idiagram.getDiagramClass().getAtMostOneItemOfClass(DataElementMap.class);
		if (dem != null) {
			final Collection<IElement> newSelection = new ArrayList<IElement>();
			for (Resource module : modules) {
				IElement element = dem.getElement(idiagram, module);
				if (element != null) {
					newSelection.add(element);
				} else {
					throw new DatabaseException("Could not find IElement for " + element); //$NON-NLS-1$
				}
			}
			
			ThreadUtils.syncExec(source_ctx.getThreadAccess(), new Runnable() {
	            @Override
	            public void run() {
	                if (source_ctx.isDisposed())
	                    return;
	                Selection selection = source_ctx.getAtMostOneItemOfClass(Selection.class);
	                if (selection != null) {
	                    // This prevents workbench selection from being left over.
	                    // Also prevents scene graph crap from being left on the screen.
	                    selection.setSelection(0, newSelection);
	                }
	        		CanvasUtils.sendCommand(source_ctx, Commands.DELETE);
	            }
	        });
			
		//}
		
		while(source_ctx.getEventQueue().size() > 0) {
			try {
				Thread.sleep(10);
			} catch (InterruptedException e) {
				throw new DatabaseException(e);
			}
		}

		ThreadUtils.syncExec(source_ctx.getThreadAccess(), new Runnable() {
            @Override
            public void run() {
            }
        });		
	        		
		}
		return true;
    }
	
}