/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.tests.commands;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.AddElement;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.tests.cases.ModelingCommandSequenceTest;
import org.simantics.modeling.tests.commands.AddDiagram;
import org.simantics.modeling.tests.commands.ResourceWriteCommand;
import org.simantics.modeling.tests.traits.SingleResourceTrait;
import org.simantics.modeling.tests.traits.SingleResourceTraitImpl;

public class AddModule
extends ResourceWriteCommand<ModelingCommandSequenceTest>
implements SingleResourceTrait {
    private AddDiagram diagram;
    private SingleResourceTrait type;
    private double x;
    private double y;

    public AddModule(AddDiagram diagram, SingleResourceTrait type, double x, double y) {
        this.diagram = diagram;
        this.type = type;
        this.x = x;
        this.y = y;
    }

    public AddModule(AddDiagram diagram, Resource type, double x, double y) {
        this.diagram = diagram;
        this.type = new SingleResourceTraitImpl(type);
        this.x = x;
        this.y = y;
    }

    @Override
    protected Resource run(WriteGraph graph, ModelingCommandSequenceTest environment) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
        Resource diagramResource = this.diagram.getResource();
        Resource resource = graph.newResource();
        graph.claim(resource, L0.InstanceOf, null, this.type.getResource((ReadGraph)graph));
        graph.claimLiteral(resource, DIA.HasTransform, G2D.Transform, (Object)new double[]{1.0, 0.0, 0.0, 1.0, this.x, this.y}, (Binding)Bindings.DOUBLE_ARRAY);
        graph.claim(resource, L0.PartOf, diagramResource);
        AddElement.claimFreshElementName((WriteGraph)graph, (Resource)diagramResource, (Resource)resource);
        OrderedSetUtils.addFirst((WriteGraph)graph, (Resource)diagramResource, (Resource)resource);
        return resource;
    }
}

