package org.simantics.modeling;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.DropActionFactory;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.diagram.Logger;
import org.simantics.scl.runtime.function.Function3;

public class SCLDropAction implements DropActionFactory {

	final private Resource rule;

	public SCLDropAction(ReadGraph graph, Resource rule) throws DatabaseException {
		this.rule = rule;
	}

	static class RuleFunctionRequest extends ResourceRead<Function3<Resource,Object,Integer,Object>> {

		protected RuleFunctionRequest(Resource rule) {
			super(rule);
		}

		@Override
		public Function3<Resource, Object, Integer, Object> perform(ReadGraph graph) throws DatabaseException {
			Variable ruleVariable = Variables.getVariable(graph, resource);
			ModelingResources MOD = ModelingResources.getInstance(graph);
			return ruleVariable.getPossiblePropertyValue(graph, MOD.SCLDropAction_action);
		}

	}

	public static class SCLDropActionRunnable implements Runnable {

		public Resource rule;
		public Resource target;
		public Object source;
		public int operation;

		public SCLDropActionRunnable(Resource rule, Resource target, Object source, int operation) {
			this.rule = rule;
			this.target = target;
			this.source = source;
			this.operation = operation;
		}

		@Override
		public void run() {
			Simantics.getSession().markUndoPoint();
			try {
				Function3<Resource, Object, Integer, Object> function = Simantics.getSession().syncRequest(new RuleFunctionRequest(rule));
				function.apply(target, source, operation);
			} catch (DatabaseException e) {
				Logger.defaultLogError(e);
			}
		}

	}

	@Override
	public Runnable create(ReadGraph g, Object target, Object source, int operation) throws DatabaseException {
		return new SCLDropActionRunnable(rule, (Resource)target, source, operation);
	}

}
