/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.message.ui.scheme;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

import org.simantics.message.IReferenceSerializer;
import org.simantics.message.ReferenceSerializationException;

/**
 * @author Tuukka Lehtonen
 */
public class URLReferenceSerializer implements IReferenceSerializer {

    @Override
    public boolean handles(Object o) {
        return o instanceof URL;
    }

    @Override
    public Object deserialize(URI data) throws ReferenceSerializationException {
        try {
            return data.toURL();
        } catch (MalformedURLException e) {
            throw new ReferenceSerializationException(e);
        }
    }

    @Override
    public URI serialize(Object o) throws ReferenceSerializationException {
        assert handles(o);
        try {
            return ((URL) o).toURI();
        } catch (URISyntaxException e) {
            throw new ReferenceSerializationException(e);
        }
    }

}
