/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.message.internal;

import java.io.File;
import java.util.Hashtable;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.simantics.message.ILogListener;
import org.simantics.message.ILogger;
import org.simantics.message.IMessageSchemeManager;

/**
 * The activator class controls the plug-in life cycle
 */
@SuppressWarnings("restriction")
public class Activator extends Plugin {

    private static final String  DEFAULT_LOG_FILE_NAME = "messages.log";

    // The plug-in ID
    public static final String   PLUGIN_ID             = "org.simantics.message";

    private static final String  LOGGER_NAME           = "org.simantics.message.logger"; //$NON-NLS-1$

    // The shared instance
    private static Activator     plugin;
    private BundleContext        bundleContext;

    // The one and only message service instance
    private Messages             messagesService;
    private MessageSchemeManager messageSchemeManagerService;

    @SuppressWarnings("rawtypes")
    private ServiceRegistration  messages              = null;
    @SuppressWarnings("rawtypes")
    private ServiceRegistration  messageSchemeManager  = null;

    private LogWriter            platformLog           = null;
    private FrameworkLog         frameworkLog          = null;

    /**
     * The constructor
     */
    public Activator() {
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext
     * )
     */
    @SuppressWarnings({ "rawtypes", "unchecked" })
    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.bundleContext = context;

        messagesService = new Messages();
        messageSchemeManagerService = new MessageSchemeManager();

        messages = bundleContext.registerService(ILogger.class.getName(), messagesService, new Hashtable());
        messageSchemeManager = bundleContext.registerService(IMessageSchemeManager.class.getName(), messageSchemeManagerService, new Hashtable<String, Object>());

        // Attach a writer listener to the Messages ILog to actually get the logs stored on disk.
        // NOTE: This must be the first listener for this ILog, to guarantee that the log on disk
        // is always up-to-date if other ILogListeners want to read it. LogView does exactly this.
        FrameworkLog log = getFrameworkLog();
        if (log != null) {
            platformLog = new LogWriter(getFrameworkLog());
            addLogListener(platformLog);
        } else
            platformLog = null;

        plugin = this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext
     * )
     */
    @Override
    public void stop(BundleContext context) throws Exception {
        if (platformLog != null)
            removeLogListener(platformLog);
        if (frameworkLog != null)
            frameworkLog.close();

        if (messageSchemeManager != null) {
            messageSchemeManager.unregister();
            messageSchemeManager = null;
            messageSchemeManagerService = null;
        }

        if (messages != null) {
            messages.unregister();
            messages = null;
            messagesService = null;
        }

        bundleContext = null;
        plugin = null;
        super.stop(context);
    }

    /**
     * Returns the shared instance
     * 
     * @return the shared instance
     */
    public static Activator getDefault() {
        return plugin;
    }

    /**
     * Returns the shared Simantics ILogger service instance.
     * 
     * @return the shared message service
     */
    public ILogger getMessages() {
        return messagesService;
    }

    /**
     * Add a listener to the Simantics platform ILogger service.
     */
    public void addLogListener(ILogListener listener) {
        getMessages().addLogListener(listener);
    }

    /**
     * Remove a listener from the Simantics platform ILogger service.
     */
    public void removeLogListener(ILogListener listener) {
        getMessages().removeLogListener(listener);
    }

    /**
     * @return
     */
    private FrameworkLog getFrameworkLog() {
        if (frameworkLog == null) {
            // TODO: make this a configurable preference, just like the osgi.logfile preference
            IPath logLocation = getStateLocation().append(DEFAULT_LOG_FILE_NAME);
            // TODO: need to clone EquinoxLogWriter and EquinoxLogFactory to this plugin
//            EquinoxLogWriter logWriter = new EclipseLogWriter(logLocation.toFile(), LOGGER_NAME, true);
//            LogServiceManager logServiceManager = new LogServiceManager(logWriter);
//            EquinoxLogFactory logFactory = new EquinoxLogFactory(logWriter, logServiceManager);
//            frameworkLog = logFactory.getService(getBundle(), null);
        }
        return frameworkLog;
    }

    /**
     * @return
     */
    public static File getLogFile() {
        return getDefault().getFrameworkLog().getFile();
    }

    /**
     * Returns the shared Simantics ILogger service instance.
     * 
     * @return the shared message service
     */
    public IMessageSchemeManager getMessageSchemeManager() {
        return messageSchemeManagerService;
    }

}
