/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.message;

import org.eclipse.core.runtime.IStatus;
import org.simantics.message.internal.Activator;

/**
 * A front-end for accessing the shared ILogger service of the Simantics
 * platform.
 * 
 * @author Tuukka Lehtonen
 */
public final class MessageService {

    /**
     * Returns the shared ILogger service of the Simantics platform.
     * 
     * @return the shared ILogger service
     */
    public static ILogger getDefault() {
        return Activator.getDefault().getMessages();
    }

    /**
     * A convenience method for logging the specified status directly into the
     * shared platform ILogger instance.
     * 
     * @param status the event to log
     */
    public static void defaultLog(IStatus status) {
        getDefault().log(status);
    }

}
