/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.rule;

import gnu.trove.map.hash.TObjectIntHashMap;
import org.simantics.db.Resource;
import org.simantics.mapping.constraint.TooManyUnboundVariablesException;
import org.simantics.mapping.rule.IRule;
import org.simantics.mapping.rule.instructions.AndRuleInstruction;
import org.simantics.mapping.rule.instructions.IRuleInstruction;
import org.simantics.utils.datastructures.persistent.ImmutableSet;

public class AndRule
implements IRule {
    IRule[] rules;

    public AndRule(IRule ... rules) {
        this.rules = rules;
    }

    @Override
    public ImmutableSet<Resource> binds() {
        ImmutableSet ret = ImmutableSet.empty();
        IRule[] iRuleArray = this.rules;
        int n = this.rules.length;
        int n2 = 0;
        while (n2 < n) {
            IRule rule = iRuleArray[n2];
            ret = ret.addAll(rule.binds());
            ++n2;
        }
        return ret;
    }

    @Override
    public IRuleInstruction createInstruction(TObjectIntHashMap<Resource> variableIds, ImmutableSet<Resource> bound) throws TooManyUnboundVariablesException {
        IRuleInstruction[] instructions = new IRuleInstruction[this.rules.length];
        int i = 0;
        while (i < this.rules.length) {
            instructions[i] = this.rules[i].createInstruction(variableIds, bound);
            ++i;
        }
        return new AndRuleInstruction(instructions);
    }
}

