/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.constraint.instructions;

import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Iterator;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.mapping.constraint.instructions.IInstruction;
import org.simantics.mapping.constraint.instructions.TripletInstruction;

public class TripletPredicateQuery
extends TripletInstruction {
    Resource predicate;

    public TripletPredicateQuery(int variable0, int variable1, int variable2, Resource predicate) {
        super(variable0, variable1, variable2);
        this.predicate = predicate;
    }

    public TripletPredicateQuery(int variable0, int variable1, int variable2) {
        super(variable0, variable1, variable2);
    }

    @Override
    public Object query(ReadGraph g, Object[] bindings) throws DatabaseException {
        Resource r0 = (Resource)bindings[this.variable0];
        Resource r2 = (Resource)bindings[this.variable2];
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Statement stat : this.predicate == null ? g.getStatements(r0, Layer0.getInstance((ReadGraph)g).IsWeaklyRelatedTo) : g.getStatements(r0, this.predicate)) {
            if (!stat.getObject().equals(r2)) continue;
            result.add(stat.getPredicate());
        }
        if (result.isEmpty()) {
            return IInstruction.FAILURE;
        }
        Iterator it = result.iterator();
        bindings[this.variable1] = it.next();
        if (it.hasNext()) {
            return it;
        }
        return null;
    }

    @Override
    public Object next(ReadGraph g, Object[] bindings, Object continuation) {
        Iterator it = (Iterator)continuation;
        if (it.hasNext()) {
            bindings[this.variable1] = it.next();
            if (it.hasNext()) {
                return it;
            }
            return null;
        }
        return IInstruction.FAILURE;
    }

    @Override
    public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
        super.collectVariables(reads, writes);
        writes.add(this.variable1);
    }
}

