/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.constraint;

import gnu.trove.map.hash.TObjectIntHashMap;
import org.simantics.db.Resource;
import org.simantics.layer0.utils.binaryPredicates.IBinaryPredicate;
import org.simantics.mapping.constraint.IConstraint;
import org.simantics.mapping.constraint.TooManyUnboundVariablesException;
import org.simantics.mapping.constraint.instructions.BinaryPredicateInstruction;
import org.simantics.mapping.constraint.instructions.BinaryPredicateObjectQuery;
import org.simantics.mapping.constraint.instructions.BinaryPredicateSubjectQuery;
import org.simantics.mapping.constraint.instructions.IInstruction;
import org.simantics.utils.datastructures.persistent.ImmutableSet;

public class BinaryPredicateConstraint
implements IConstraint {
    Resource variable0;
    Resource variable1;
    IBinaryPredicate predicate;

    public BinaryPredicateConstraint(IBinaryPredicate predicate, Resource variable0, Resource variable1) {
        this.predicate = predicate;
        this.variable0 = variable0;
        this.variable1 = variable1;
    }

    @Override
    public ImmutableSet<Resource> binds() {
        return ImmutableSet.of((Comparable[])new Resource[]{this.variable0, this.variable1});
    }

    @Override
    public IInstruction createInstruction(TObjectIntHashMap<Resource> variableIds, ImmutableSet<Resource> bound) throws TooManyUnboundVariablesException {
        int id0 = variableIds.get((Object)this.variable0);
        int id1 = variableIds.get((Object)this.variable1);
        if (bound.contains((Comparable)this.variable0)) {
            if (bound.contains((Comparable)this.variable1)) {
                return new BinaryPredicateInstruction(id0, id1, this.predicate);
            }
            return new BinaryPredicateObjectQuery(id0, id1, this.predicate);
        }
        if (bound.contains((Comparable)this.variable1)) {
            return new BinaryPredicateSubjectQuery(id0, id1, this.predicate);
        }
        throw new TooManyUnboundVariablesException();
    }

    @Override
    public int isApplicable(ImmutableSet<Resource> bound) {
        if (bound.contains((Comparable)this.variable0)) {
            if (bound.contains((Comparable)this.variable1)) {
                return Integer.MAX_VALUE;
            }
            if (this.predicate.supportsGetObjects()) {
                return Integer.MAX_VALUE;
            }
            return 0;
        }
        if (bound.contains((Comparable)this.variable1) && this.predicate.supportsGetSubjects()) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }
}

