/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.rule.instructions;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;

import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.triggers.IModification;
import org.simantics.utils.threads.logger.ITask;
import org.simantics.utils.threads.logger.ThreadLogger;

public class ProfileRuleInstruction implements IRuleInstruction {

	String name;
	IRuleInstruction rule;		
	
	public ProfileRuleInstruction(String name, IRuleInstruction rule) {
		this.name = name;
		this.rule = rule;
	}

	@Override
	public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
		rule.collectVariables(reads, writes);		
	}

	@Override
	public IModification execute(ReadGraph g, Object[] bindings) throws DatabaseException {
		ITask task = ThreadLogger.getInstance().begin(name+".execute");
		final IModification modi = rule.execute(g, bindings);
		task.finish();
		if(modi==null)
			return null;
		return new IModification() {

			@Override
			public void perform(WriteGraph g) throws DatabaseException {
				ITask task = ThreadLogger.getInstance().begin(name + ".perform");
				modi.perform(g);
				task.finish();
			}
			
		};
	}
	
	@Override
	public void doExecute(WriteGraph g, Object[] bindings) throws DatabaseException {
		ITask task = ThreadLogger.getInstance().begin(name+".doExecute");
		rule.doExecute(g, bindings);		
		task.finish();
	}

	@Override
	public void mapVariables(TIntIntHashMap map) {
		rule.mapVariables(map);		
	}

	@Override
	public void toString(StringBuilder b, int indent) {
		rule.toString(b, indent);
	}

}
