/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.rule.instructions;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;

import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.triggers.IModification;

public class PrintRuleInstruction implements IRuleInstruction {

	String text;
	
	public PrintRuleInstruction(String text) {
		this.text = text;
	}

	@Override
	public void collectVariables(TIntHashSet reads, TIntHashSet writes) {		
	}

	@Override
	public IModification execute(ReadGraph g, Object[] bindings) throws DatabaseException {
		System.out.println("execute " + text);
		return null;
	}
	
	@Override
	public void doExecute(WriteGraph g, Object[] bindings) throws DatabaseException {
		System.out.println("doExecute " + text);		
	}

	@Override
	public void mapVariables(TIntIntHashMap map) {
	}

	@Override
	public void toString(StringBuilder b, int indent) {
		b.append("print(" + text + ")");
	}

}
