/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.rule.instructions;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;

import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.triggers.IModification;
import org.simantics.mapping.constraint.instructions.IInstruction;

public interface IRuleInstruction {
	public static final boolean DEBUG = false;
	public static final String INDENTATION = IInstruction.INDENTATION;
	
	void collectVariables(TIntHashSet reads, TIntHashSet writes);
	void mapVariables(TIntIntHashMap map);
	IModification execute(ReadGraph g, Object[] bindings) throws DatabaseException;
	void doExecute(WriteGraph g, Object[] bindings) throws DatabaseException;

	void toString(StringBuilder b, int indent);
}
