/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.rule.instructions;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;

import java.util.Arrays;

import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.triggers.IModification;
import org.simantics.mapping.IContextualModification;
import org.simantics.mapping.constraint.instructions.IInstruction;

public class DenyRuleInstruction implements IRuleInstruction {

	IInstruction instruction;	
	
	public DenyRuleInstruction(IInstruction instruction) {
		this.instruction = instruction;
	}
	
	@Override
	public IModification execute(ReadGraph g, Object[] bindings) throws DatabaseException {
		final IContextualModification modi = instruction.deny(g, bindings); 
		if(modi != null) {
			final Object[] curBindings = Arrays.copyOf(bindings, bindings.length);
			return new IModification() {

				@Override
				public void perform(WriteGraph g) throws DatabaseException {
					modi.perform(g, curBindings);
				}
				
			};
		}
		return null;
	}
	
	@Override
	public void doExecute(WriteGraph g, Object[] bindings) throws DatabaseException {
		instruction.doDeny(g, bindings);
	}

	@Override
	public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
		instruction.collectVariables(reads, writes);
	}

	@Override
	public void mapVariables(TIntIntHashMap map) {
		instruction.mapVariables(map);
	}
	
	@Override
	public void toString(StringBuilder b, int indent) {		
		b.append("deny ");
		instruction.toString(b, indent+1);	
	}
}
