/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.constraint.instructions;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;

import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;

public abstract class Instruction1 implements IInstruction {
	int variable0;	
	
	public Instruction1(int variable0) {
		this.variable0 = variable0;
	}

	@Override
	public void mapVariables(TIntIntHashMap map) {
		variable0 = map.get(variable0);
	}
	
	@Override
	public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
		reads.add(variable0);
	}
	
	@Override
	public void doClaim(WriteGraph g, Object[] bindings) throws DatabaseException {
		claim(g, bindings).perform(g, bindings);
	}
	
	@Override
	public void doDeny(WriteGraph g, Object[] bindings) throws DatabaseException {
		deny(g, bindings).perform(g, bindings);
	}
}
