/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.lz4;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.util.Native;
import org.simantics.compressions.impl.Buffers;
import org.simantics.lz4.impl.LZ4InputStream;
import org.simantics.lz4.impl.LZ4OutputStream;

public class LZ4 {
    private static LZ4Factory INSTANCE = null;

    static {
        Native.load();
        INSTANCE = LZ4Factory.fastestInstance();
    }

    public static LZ4Factory getInstance() {
        return INSTANCE;
    }

    public static boolean isNativeInitialized() {
        return Native.isLoaded();
    }

    public static int compressBound(int inputSize) {
        return INSTANCE.fastCompressor().maxCompressedLength(inputSize);
    }

    public static int compressBuffer(ByteBuffer input, int inputOffset, int length, ByteBuffer output, int outputOffset) {
        if (output.isReadOnly()) {
            throw new IllegalArgumentException("read-only output buffer");
        }
        if (input.isDirect() && output.isDirect()) {
            return INSTANCE.fastCompressor().compress(input, inputOffset, length, output, outputOffset, output.capacity() - outputOffset);
        }
        byte[] inarr = Buffers.getInputArray((ByteBuffer)input);
        byte[] outarr = Buffers.getOutputArray((ByteBuffer)output);
        int result = INSTANCE.fastCompressor().compress(inarr, inputOffset, length, outarr, outputOffset, outarr.length - outputOffset);
        Buffers.writeOutput((ByteBuffer)output, (byte[])outarr);
        return result;
    }

    public static int decompressBuffer(ByteBuffer input, int inputOffset, int length, ByteBuffer output, int outputOffset, int maxout) {
        if (output.isReadOnly()) {
            throw new IllegalArgumentException("read-only output buffer");
        }
        if (input.isDirect() && output.isDirect()) {
            return INSTANCE.safeDecompressor().decompress(input, inputOffset, length, output, outputOffset, maxout);
        }
        byte[] inarr = Buffers.getInputArray((ByteBuffer)input);
        byte[] outarr = Buffers.getOutputArray((ByteBuffer)output);
        int result = INSTANCE.safeDecompressor().decompress(inarr, inputOffset, length, outarr, outputOffset, maxout);
        Buffers.writeOutput((ByteBuffer)output, (byte[])outarr);
        return result;
    }

    public static InputStream read(File file) throws FileNotFoundException {
        return new LZ4InputStream(file);
    }

    public static InputStream read(InputStream input) {
        return new LZ4InputStream(input);
    }

    public static OutputStream write(File file) throws FileNotFoundException {
        return new LZ4OutputStream(file);
    }

    public static OutputStream write(OutputStream output) {
        return new LZ4OutputStream(output);
    }
}

