/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4ByteBufferUtils;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.jpountz.lz4.LZ4SafeUtils;
import net.jpountz.util.ByteBufferUtils;
import net.jpountz.util.SafeUtils;

final class LZ4JavaSafeFastDecompressor
extends LZ4FastDecompressor {
    public static final LZ4FastDecompressor INSTANCE = new LZ4JavaSafeFastDecompressor();

    LZ4JavaSafeFastDecompressor() {
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    @Override
    public int decompress(byte[] src, int srcOff, byte[] dest, int destOff, int destLen) {
        SafeUtils.checkRange(src, srcOff);
        SafeUtils.checkRange(dest, destOff, destLen);
        if (destLen == 0) {
            if (SafeUtils.readByte(src, srcOff) == 0) return 1;
            throw new LZ4Exception("Malformed input at " + srcOff);
        }
        int destEnd = destOff + destLen;
        int sOff = srcOff;
        int dOff = destOff;
        while (true) {
            int matchCopyEnd;
            int matchLen;
            int matchOff;
            block15: {
                int len;
                block17: {
                    byte by;
                    block16: {
                        int literalCopyEnd;
                        int literalLen;
                        int token;
                        block12: {
                            int len2;
                            block14: {
                                byte by2;
                                block13: {
                                    token = SafeUtils.readByte(src, sOff) & 0xFF;
                                    ++sOff;
                                    literalLen = token >>> 4;
                                    if (literalLen != 15) break block12;
                                    len2 = -1;
                                    if (!true) break block13;
                                    by2 = SafeUtils.readByte(src, sOff++);
                                    len2 = by2;
                                    if (by2 != -1) break block14;
                                }
                                do {
                                    literalLen += 255;
                                    by2 = SafeUtils.readByte(src, sOff++);
                                    len2 = by2;
                                } while (by2 == -1);
                            }
                            literalLen += len2 & 0xFF;
                        }
                        if ((literalCopyEnd = dOff + literalLen) > destEnd - 8) {
                            if (literalCopyEnd != destEnd) {
                                throw new LZ4Exception("Malformed input at " + sOff);
                            }
                            LZ4SafeUtils.safeArraycopy(src, sOff, dest, dOff, literalLen);
                            dOff = literalCopyEnd;
                            return (sOff += literalLen) - srcOff;
                        }
                        LZ4SafeUtils.wildArraycopy(src, sOff, dest, dOff, literalLen);
                        dOff = literalCopyEnd;
                        int matchDec = SafeUtils.readShortLE(src, sOff += literalLen);
                        sOff += 2;
                        matchOff = dOff - matchDec;
                        if (matchOff < destOff) {
                            throw new LZ4Exception("Malformed input at " + sOff);
                        }
                        matchLen = token & 0xF;
                        if (matchLen != 15) break block15;
                        len = -1;
                        if (!true) break block16;
                        by = SafeUtils.readByte(src, sOff++);
                        len = by;
                        if (by != -1) break block17;
                    }
                    do {
                        matchLen += 255;
                        by = SafeUtils.readByte(src, sOff++);
                        len = by;
                    } while (by == -1);
                }
                matchLen += len & 0xFF;
            }
            if ((matchCopyEnd = dOff + (matchLen += 4)) > destEnd - 8) {
                if (matchCopyEnd > destEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                LZ4SafeUtils.safeIncrementalCopy(dest, matchOff, dOff, matchLen);
            } else {
                LZ4SafeUtils.wildIncrementalCopy(dest, matchOff, dOff, matchCopyEnd);
            }
            dOff = matchCopyEnd;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    @Override
    public int decompress(ByteBuffer src, int srcOff, ByteBuffer dest, int destOff, int destLen) {
        if (src.hasArray() && dest.hasArray()) {
            return this.decompress(src.array(), srcOff + src.arrayOffset(), dest.array(), destOff + dest.arrayOffset(), destLen);
        }
        src = ByteBufferUtils.inNativeByteOrder(src);
        dest = ByteBufferUtils.inNativeByteOrder(dest);
        ByteBufferUtils.checkRange(src, srcOff);
        ByteBufferUtils.checkRange(dest, destOff, destLen);
        if (destLen == 0) {
            if (ByteBufferUtils.readByte(src, srcOff) == 0) return 1;
            throw new LZ4Exception("Malformed input at " + srcOff);
        }
        int destEnd = destOff + destLen;
        int sOff = srcOff;
        int dOff = destOff;
        while (true) {
            int matchCopyEnd;
            int matchLen;
            int matchOff;
            block16: {
                int len;
                block18: {
                    byte by;
                    block17: {
                        int literalCopyEnd;
                        int literalLen;
                        int token;
                        block13: {
                            int len2;
                            block15: {
                                byte by2;
                                block14: {
                                    token = ByteBufferUtils.readByte(src, sOff) & 0xFF;
                                    ++sOff;
                                    literalLen = token >>> 4;
                                    if (literalLen != 15) break block13;
                                    len2 = -1;
                                    if (!true) break block14;
                                    by2 = ByteBufferUtils.readByte(src, sOff++);
                                    len2 = by2;
                                    if (by2 != -1) break block15;
                                }
                                do {
                                    literalLen += 255;
                                    by2 = ByteBufferUtils.readByte(src, sOff++);
                                    len2 = by2;
                                } while (by2 == -1);
                            }
                            literalLen += len2 & 0xFF;
                        }
                        if ((literalCopyEnd = dOff + literalLen) > destEnd - 8) {
                            if (literalCopyEnd != destEnd) {
                                throw new LZ4Exception("Malformed input at " + sOff);
                            }
                            LZ4ByteBufferUtils.safeArraycopy(src, sOff, dest, dOff, literalLen);
                            dOff = literalCopyEnd;
                            return (sOff += literalLen) - srcOff;
                        }
                        LZ4ByteBufferUtils.wildArraycopy(src, sOff, dest, dOff, literalLen);
                        dOff = literalCopyEnd;
                        int matchDec = ByteBufferUtils.readShortLE(src, sOff += literalLen);
                        sOff += 2;
                        matchOff = dOff - matchDec;
                        if (matchOff < destOff) {
                            throw new LZ4Exception("Malformed input at " + sOff);
                        }
                        matchLen = token & 0xF;
                        if (matchLen != 15) break block16;
                        len = -1;
                        if (!true) break block17;
                        by = ByteBufferUtils.readByte(src, sOff++);
                        len = by;
                        if (by != -1) break block18;
                    }
                    do {
                        matchLen += 255;
                        by = ByteBufferUtils.readByte(src, sOff++);
                        len = by;
                    } while (by == -1);
                }
                matchLen += len & 0xFF;
            }
            if ((matchCopyEnd = dOff + (matchLen += 4)) > destEnd - 8) {
                if (matchCopyEnd > destEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                LZ4ByteBufferUtils.safeIncrementalCopy(dest, matchOff, dOff, matchLen);
            } else {
                LZ4ByteBufferUtils.wildIncrementalCopy(dest, matchOff, dOff, matchCopyEnd);
            }
            dOff = matchCopyEnd;
        }
    }
}

