/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.operation;

import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.service.QueryControl;

public class OperationResource {
    public final Resource AbstractContextualList;
    public final Resource ConditionalList;
    public final Resource ContextualList;
    public final Resource HasCondition;
    public final Resource HasElseElement;
    public final Resource HasThenElement;
    public final Resource Operation;
    public final Resource TypeBasedList;

    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        }
        catch (DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    public OperationResource(ReadGraph graph) {
        this.AbstractContextualList = OperationResource.getResourceOrNull(graph, "http://www.simantics.org/Layer0X-1.1/Operation/AbstractContextualList");
        this.ConditionalList = OperationResource.getResourceOrNull(graph, "http://www.simantics.org/Layer0X-1.1/Operation/ConditionalList");
        this.ContextualList = OperationResource.getResourceOrNull(graph, "http://www.simantics.org/Layer0X-1.1/Operation/ContextualList");
        this.HasCondition = OperationResource.getResourceOrNull(graph, "http://www.simantics.org/Layer0X-1.1/Operation/HasCondition");
        this.HasElseElement = OperationResource.getResourceOrNull(graph, "http://www.simantics.org/Layer0X-1.1/Operation/HasElseElement");
        this.HasThenElement = OperationResource.getResourceOrNull(graph, "http://www.simantics.org/Layer0X-1.1/Operation/HasThenElement");
        this.Operation = OperationResource.getResourceOrNull(graph, "http://www.simantics.org/Layer0X-1.1/Operation/Operation");
        this.TypeBasedList = OperationResource.getResourceOrNull(graph, "http://www.simantics.org/Layer0X-1.1/Operation/TypeBasedList");
    }

    public static OperationResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        OperationResource ret = (OperationResource)session.peekService(OperationResource.class);
        if (ret == null) {
            QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
            ret = new OperationResource(qc.getIndependentGraph(graph));
            session.registerService(OperationResource.class, (Object)ret);
        }
        return ret;
    }

    public static OperationResource getInstance(RequestProcessor session) throws DatabaseException {
        OperationResource ret = (OperationResource)session.peekService(OperationResource.class);
        if (ret == null) {
            ret = (OperationResource)session.syncRequest((Read)new Read<OperationResource>(){

                public OperationResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
                    return new OperationResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(OperationResource.class, (Object)ret);
        }
        return ret;
    }

    public static class URIs {
        public static final String AbstractContextualList = "http://www.simantics.org/Layer0X-1.1/Operation/AbstractContextualList";
        public static final String ConditionalList = "http://www.simantics.org/Layer0X-1.1/Operation/ConditionalList";
        public static final String ContextualList = "http://www.simantics.org/Layer0X-1.1/Operation/ContextualList";
        public static final String HasCondition = "http://www.simantics.org/Layer0X-1.1/Operation/HasCondition";
        public static final String HasElseElement = "http://www.simantics.org/Layer0X-1.1/Operation/HasElseElement";
        public static final String HasThenElement = "http://www.simantics.org/Layer0X-1.1/Operation/HasThenElement";
        public static final String Operation = "http://www.simantics.org/Layer0X-1.1/Operation/Operation";
        public static final String TypeBasedList = "http://www.simantics.org/Layer0X-1.1/Operation/TypeBasedList";
    }
}

