/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.binaryPredicates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.binaryPredicates.BinaryPredicate;
import org.simantics.utils.datastructures.Pair;

public class OrderedSetElementsPredicate
extends BinaryPredicate {
    public static final OrderedSetElementsPredicate INSTANCE = new OrderedSetElementsPredicate();

    @Override
    public Collection<Resource> getObjects(ReadGraph g, Resource subject) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        if (g.isInstanceOf(subject, l0.OrderedSet)) {
            return OrderedSetUtils.toList((ReadGraph)g, (Resource)subject);
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<Pair<Resource, Resource>> getStatements(ReadGraph g) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Resource> getSubjects(ReadGraph g, Resource object) throws DatabaseException {
        ArrayList<Resource> result = new ArrayList<Resource>(1);
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        for (Statement stat : g.getStatements(object, l0.IsWeaklyRelatedTo)) {
            Resource pred = stat.getPredicate();
            if (!g.isInstanceOf(pred, l0.OrderedSet) || pred.equals(object)) continue;
            result.add(pred);
        }
        return result;
    }

    @Override
    public boolean has(ReadGraph g, Resource subject, Resource object) throws DatabaseException {
        return OrderedSetUtils.contains((ReadGraph)g, (Resource)subject, (Resource)object) && g.isInstanceOf(subject, Layer0.getInstance((ReadGraph)g).OrderedSet);
    }

    @Override
    public boolean supportsGetObjects() {
        return true;
    }

    @Override
    public boolean supportsGetStatements() {
        return false;
    }

    @Override
    public boolean supportsGetSubjects() {
        return true;
    }

    @Override
    public void add(WriteGraph g, Resource subject, Resource object) throws DatabaseException {
        OrderedSetUtils.add((WriteGraph)g, (Resource)subject, (Resource)object);
    }

    @Override
    public void remove(WriteGraph g, Resource subject, Resource object) throws DatabaseException {
        OrderedSetUtils.remove((WriteGraph)g, (Resource)subject, (Resource)object);
    }

    @Override
    public boolean supportsAdditions() {
        return true;
    }

    @Override
    public boolean supportsRemovals() {
        return true;
    }
}

