package org.simantics.jdbc.ontology;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class JDBCResource {
    
    public final Resource Session;
    public final Resource Session_hasValue;
    public final Resource Session_hasValue_Inverse;
        
    public static class URIs {
        public static final String Session = "http://www.simantics.org/JDBC-1.0/Session";
        public static final String Session_hasValue = "http://www.simantics.org/JDBC-1.0/Session/hasValue";
        public static final String Session_hasValue_Inverse = "http://www.simantics.org/JDBC-1.0/Session/hasValue/Inverse";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public JDBCResource(ReadGraph graph) {
        Session = getResourceOrNull(graph, URIs.Session);
        Session_hasValue = getResourceOrNull(graph, URIs.Session_hasValue);
        Session_hasValue_Inverse = getResourceOrNull(graph, URIs.Session_hasValue_Inverse);
    }
    
    public static JDBCResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        JDBCResource ret = session.peekService(JDBCResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new JDBCResource(qc.getIndependentGraph(graph));
            session.registerService(JDBCResource.class, ret);
        }
        return ret;
    }
    
    public static JDBCResource getInstance(RequestProcessor session) throws DatabaseException {
        JDBCResource ret = session.peekService(JDBCResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<JDBCResource>() {
                public JDBCResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new JDBCResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(JDBCResource.class, ret);
        }
        return ret;
    }
    
}

