/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui.handler;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.issues.common.AllVisibleIssues;
import org.simantics.issues.common.DynamicIssueSources;
import org.simantics.issues.ui.handler.Messages;
import org.simantics.operation.Layer0X;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.DataContainer;
import org.simantics.utils.FileUtils;
import org.simantics.utils.strings.StringUtils;
import org.simantics.utils.ui.ExceptionUtils;

public class ExportIssuesAsCsv
extends AbstractHandler {
    private static final String PROP_LAST_VALIDATION_REPORT_PATH = "validation.report.path";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        try {
            String fileName = this.generateFileName();
            this.validate(window, fileName);
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        return null;
    }

    private String generateFileName() throws DatabaseException {
        String generatedName = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                Iterator iterator = ((Collection)graph.syncRequest((Read)new ObjectsWithType(Simantics.getProjectResource(), L0X.Activates, SIMU.Model))).iterator();
                if (iterator.hasNext()) {
                    Resource model = (Resource)iterator.next();
                    return String.valueOf(NameUtils.getSafeName((ReadGraph)graph, (Resource)model)) + ".txt";
                }
                return "issues.txt";
            }
        });
        if (!FileUtils.isValidFileName((String)generatedName)) {
            generatedName = (String)Bindings.STR_VARIANT.createUnchecked((Binding)Bindings.STRING, (Object)generatedName);
        }
        return generatedName;
    }

    public void validate(IWorkbenchWindow window, String fileName) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.simantics.issues.ui");
        String lastReportPath = prefs.get(PROP_LAST_VALIDATION_REPORT_PATH, null);
        Shell parentShell = null;
        if (window != null) {
            parentShell = window.getShell();
        }
        new DataContainer();
        FileDialog fd = new FileDialog(parentShell, 8192);
        fd.setText(Messages.ExportIssuesAsCsv_SelectValidationOutput);
        fd.setFilterExtensions(new String[]{"*.txt", "*.*"});
        fd.setFilterNames(new String[]{Messages.ExportIssuesAsCsv_CommaSeparatedValues, Messages.ExportIssuesAsCsv_AllFiles});
        if (lastReportPath != null) {
            fd.setFilterPath(lastReportPath);
        }
        fd.setFileName(fileName);
        String path = fd.open();
        if (path != null) {
            prefs.put(PROP_LAST_VALIDATION_REPORT_PATH, path);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                ExceptionUtils.logError((Throwable)e);
            }
        } else {
            return;
        }
        try {
            window.getWorkbench().getProgressService().busyCursorWhile(monitor -> {
                try {
                    try {
                        Throwable throwable = null;
                        Object var4_6 = null;
                        try (PrintStream out = new PrintStream(new File(path));){
                            this.export(monitor, out);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            ExceptionUtils.logAndShowError((Throwable)e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
    }

    private void export(IProgressMonitor monitor, final PrintStream out) throws DatabaseException {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ExportIssuesAsCsv_ExportIssues, (int)-1);
        Simantics.getSession().syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                Collection activeIssues = (Collection)graph.syncRequest((Read)new AllVisibleIssues(Simantics.getProjectResource()));
                out.println("# Exported issues (" + activeIssues.size() + ")");
                for (Variable issue : activeIssues) {
                    ExportIssuesAsCsv.this.exportIssue(graph, issue, out, 0);
                    progress.worked(1);
                }
                Map dynamicIssueSources = ExportIssuesAsCsv.this.nameMap(graph, (Set)graph.syncRequest((Read)new DynamicIssueSources(Simantics.getProjectResource())));
                if (!dynamicIssueSources.isEmpty()) {
                    out.println();
                    out.println("# Dynamic Issues");
                    for (Variable source : dynamicIssueSources.values()) {
                        ExportIssuesAsCsv.this.exportDynamicIssueSource((IProgressMonitor)progress, graph, source, out, 0);
                    }
                }
            }
        });
    }

    private Map<String, Variable> nameMap(ReadGraph graph, Set<Variable> sources) throws DatabaseException {
        TreeMap<String, Variable> sorted = new TreeMap<String, Variable>();
        for (Variable v : sources) {
            String name = (String)v.getPossiblePropertyValue(graph, "HasDescription", (Binding)Bindings.STRING);
            if (name == null) {
                name = v.getName(graph);
            }
            sorted.put(name, v);
        }
        return sorted;
    }

    protected void exportDynamicIssueSource(IProgressMonitor monitor, ReadGraph graph, Variable issue, PrintStream out, int startColumn) throws DatabaseException {
        this.exportIssue(graph, issue, out, startColumn);
        for (Variable child : issue.getChildren(graph)) {
            this.exportDynamicIssueSource(monitor, graph, child, out, startColumn + 1);
            monitor.worked(1);
        }
    }

    private void exportIssue(ReadGraph graph, Variable issue, PrintStream out, int startColumn) throws DatabaseException {
        String description = StringUtils.safeString((String)((String)issue.getPossiblePropertyValue(graph, "HasDescription")));
        String severity = StringUtils.safeString((String)((String)issue.getPossiblePropertyValue(graph, "severity")));
        String resource = StringUtils.safeString((String)((String)issue.getPossiblePropertyValue(graph, "resource")));
        String path = StringUtils.safeString((String)((String)issue.getPossiblePropertyValue(graph, "path")));
        int i = 0;
        while (i < startColumn) {
            out.print(";");
            ++i;
        }
        out.println(String.valueOf(description) + ";" + severity + ";" + resource + ";" + path);
    }
}

