/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.image.ui;

import java.io.File;
import java.io.IOException;
import java.util.Collection;

import org.eclipse.osgi.util.NLS;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.ui.ErrorLogger;

/**
 * @author Tuukka Lehtonen
 */
public class CreateImages extends WriteRequest {

    private Resource         container;
    private Collection<File> files;

    public CreateImages(Resource container, Collection<File> files) {
        this.container = container;
        this.files = files;
    }

    @Override
    public void perform(WriteGraph graph) throws DatabaseException {
        for (File file : files) {
            try {
                ImageSource src = ImportImagesActionFactory.toImageSource(file);
                new CreateImage(container, src).perform(graph);
            } catch (IOException e) {
                ErrorLogger.defaultLogError(NLS.bind(Messages.CreateImages_FailedToImportPage, file.getName()), e); 
            }
        }
    }

}