/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.csv;

public enum ColumnSeparator {
    COMMA("Comma (,)", ","),
    TAB("Tabulator (\\t)", "\t"),
    SEMICOLON("Semicolon (;)", ";"),
    COLON("Colon (:)", ":"),
    SPACE("Space ( )", " ");

    public String label;
    public String preference;

    private ColumnSeparator(String label, String preference) {
        this.label = label;
        this.preference = preference;
    }

    public static ColumnSeparator fromIndex(int index) {
        return ColumnSeparator.values()[index];
    }

    public String toPreference() {
        return this.preference;
    }

    public static ColumnSeparator fromPreference(String preference) {
        ColumnSeparator[] columnSeparatorArray = ColumnSeparator.values();
        int n = columnSeparatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnSeparator s = columnSeparatorArray[n2];
            if (s.preference.equals(preference)) {
                return s;
            }
            ++n2;
        }
        return COMMA;
    }
}

